/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.ToolTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.MaterialTool;
import org.gtreimagined.gtlib.util.Utils;

public class ItemTurbineRotor
extends MaterialTool {
    public ItemTurbineRotor(String domain, GTToolType type, GTItemTier tier, Item.Properties properties) {
        super(domain, type, tier, properties);
    }

    public float getEfficiency() {
        return 60.0f + 10.0f * (this.type.getBaseAttackDamage() + this.itemTier.m_6631_());
    }

    public int speedMultiplier() {
        if (this.type == ToolTypes.TURBINE_ROTOR) {
            return 2;
        }
        if (this.type == ToolTypes.LARGE_TURBINE_ROTOR) {
            return 3;
        }
        if (this.type == ToolTypes.HUGE_TURBINE_ROTOR) {
            return 4;
        }
        return 1;
    }

    public float getSpeed() {
        return this.itemTier.m_6624_() * (float)this.speedMultiplier();
    }

    public Material getRodMaterial() {
        if (this.type == ToolTypes.TURBINE_ROTOR) {
            return Materials.Titanium;
        }
        if (this.type == ToolTypes.LARGE_TURBINE_ROTOR) {
            return Materials.TungstenSteel;
        }
        if (this.type == ToolTypes.HUGE_TURBINE_ROTOR) {
            return Materials.Adamantium;
        }
        return Materials.Magnalium;
    }

    public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        super.onGenericAddInformation(stack, tooltip, flag);
        tooltip.add((Component)Utils.translatable((String)"gt5r.rotor.tooltip.efficiency", (Object[])new Object[]{Utils.literal((String)("" + this.getEfficiency())).m_130940_(ChatFormatting.BLUE)}));
        tooltip.add((Component)Utils.translatable((String)"gt5r.rotor.tooltip.steam_flow", (Object[])new Object[]{Utils.literal((String)("" + Math.max(Float.MIN_NORMAL, this.getSpeed() * 1000.0f))).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
        tooltip.add((Component)Utils.translatable((String)"gt5r.rotor.tooltip.gas_flow", (Object[])new Object[]{Utils.literal((String)("" + Math.max(Float.MIN_NORMAL, this.getSpeed() * 50.0f))).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
    }

    public ItemStack resolveStack(Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        return new ItemStack((ItemLike)this);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotType, ItemStack stack) {
        return HashMultimap.create();
    }
}

