/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gt5r.items.ItemDepletedRod;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemNuclearFuelRod
extends ItemBasic<ItemNuclearFuelRod>
implements IItemReactorRod,
IMaterialObject {
    private final Material material;
    private final int emission;
    private final int self;
    private final int maximum;
    private final int div;
    private final long durability;

    public ItemNuclearFuelRod(String domain, Material material, long durability, int emission, int self, int maximum, int div) {
        super(domain, material.getId() + "_nuclear_rod", new Item.Properties().m_41487_(16).m_41491_(Ref.TAB_ITEMS));
        this.material = material;
        this.emission = emission;
        this.self = self;
        this.maximum = maximum;
        this.div = div;
        this.durability = durability;
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 0) {
            return this.material.getRGB();
        }
        return IItemReactorRod.super.getItemColor(stack, block, i);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission_info", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self_info", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum_info", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum_1", (Object[])new Object[0]).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor_info", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor_1", (Object[])new Object[0]).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.AQUA));
        long durability = stack.m_41783_() != null && stack.m_41783_().m_128441_("rodDurability") ? stack.m_41783_().m_128454_("rodDurability") : this.durability;
        tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.remaining", (Object[])new Object[]{Utils.literal((String)("" + durability / 120000L)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.AQUA));
        if (level != null) {
            int timeIndex = (int)(level.m_46467_() / 100L % 10L);
            switch (timeIndex) {
                case 0: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.2", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.DistilledWater.getLiquid(1)), FluidUtils.getFluidDisplayName((FluidStack)Materials.SemiheavyWater.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.1", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 1: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.HeavyWater.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + CodeUtils.divup((long)this.maximum, (long)8L))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.1", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 2: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.TritiatedWater.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + CodeUtils.divup((long)this.maximum, (long)16L))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.moderated.1", (Object[])new Object[0]).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GREEN));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 3: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.Tin.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + (this.div - 1))).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.heat", (Object[])new Object[]{"1/3"}).m_130940_(ChatFormatting.GREEN));
                    if (this.div > 5) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 4: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.Sodium.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + (this.div - 1))).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.heat", (Object[])new Object[]{"1/6"}).m_130940_(ChatFormatting.GREEN));
                    if (this.div > 5) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 5: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.Coolant.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission * 4)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self * 4)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div * 2)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    if (this.div > 2) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 6: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.LithiumChloride.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + ((long)this.emission - CodeUtils.divup((long)this.emission, (long)2L)))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self * 5)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + ((long)this.maximum + CodeUtils.divup((long)this.maximum, (long)4L)))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 7: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.ThoriumSalt.getLiquid(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + ((long)this.emission - CodeUtils.divup((long)this.emission, (long)2L)))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)"0").m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum * 4)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + (this.div - 1))).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    if (this.div > 5) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 8: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.CarbonDioxide.getGas(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + this.emission)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self * 3)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                    break;
                }
                case 9: {
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.when_used.1", (Object[])new Object[]{FluidUtils.getFluidDisplayName((FluidStack)Materials.Helium.getGas(1))}).m_130940_(ChatFormatting.AQUA));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.emission", (Object[])new Object[]{Utils.literal((String)("" + ((long)this.emission - CodeUtils.divup((long)this.emission, (long)2L)))).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.self", (Object[])new Object[]{Utils.literal((String)("" + this.self)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.maximum", (Object[])new Object[]{Utils.literal((String)("" + this.maximum)).m_130940_(ChatFormatting.WHITE), Utils.translatable((String)"tooltip.gt5r.nuclear_rod.neutrons", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE)}).m_130940_(ChatFormatting.GREEN));
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.factor", (Object[])new Object[]{Utils.literal((String)("1/" + this.div)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.YELLOW));
                    if (this.div > 4) break;
                    tooltipComponents.add((Component)Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.0", (Object[])new Object[]{Utils.translatable((String)"tooltip.gt5r.nuclear_rod.critical.1", (Object[])new Object[0]).m_130940_(level.m_46467_() % 20L <= 9L ? ChatFormatting.RED : ChatFormatting.WHITE)}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    public Texture[] getTextures() {
        return new Texture[]{new Texture("gt5r", "item/basic/nuclear_fuel_rod"), new Texture("gt5r", "item/basic/empty_nuclear_fuel_rod")};
    }

    @Override
    public boolean isReactorRod(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isModerated(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("oldModerated");
    }

    @Override
    public void updateModeration(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128379_("oldModerated", nbt.m_128471_("moderated"));
        nbt.m_128379_("moderated", false);
    }

    @Override
    public int getReactorRodNeutronEmission(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        int tNeutronOther = this.emission;
        int tNeutronSelf = this.self;
        int tNeutronDiv = this.div;
        FluidStack coldCoolant = reactor.fluidHandler.map(f -> f.getInputTanks().getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (coldCoolant.getFluid().m_205067_(Materials.Coolant.getFluidTag())) {
            tNeutronOther *= 4;
            tNeutronSelf *= 4;
            tNeutronDiv *= 2;
        } else if (coldCoolant.getFluid().m_205067_(Materials.CarbonDioxide.getFluidTag())) {
            tNeutronSelf *= 3;
        } else if (coldCoolant.getFluid().m_205067_(Materials.Helium.getFluidTag())) {
            tNeutronOther = (int)((long)tNeutronOther - CodeUtils.divup((long)this.emission, (long)2L));
        } else if (coldCoolant.getFluid().m_205067_(Materials.LithiumChloride.getFluidTag())) {
            tNeutronOther = (int)((long)tNeutronOther - CodeUtils.divup((long)this.emission, (long)2L));
            tNeutronSelf *= 5;
        } else if (coldCoolant.getFluid().m_205067_(Materials.ThoriumSalt.getFluidTag())) {
            tNeutronOther = (int)((long)tNeutronOther - CodeUtils.divup((long)this.emission, (long)2L));
            tNeutronSelf = 0;
            --tNeutronDiv;
        } else if (coldCoolant.getFluid().m_205067_(Materials.Sodium.getFluidTag()) || coldCoolant.getFluid().m_205067_(Materials.Tin.getFluidTag())) {
            --tNeutronDiv;
        }
        int n = slot;
        reactor.mNeutronCounts[n] = reactor.mNeutronCounts[n] + tNeutronSelf;
        long tEmission = (long)tNeutronOther + CodeUtils.divup((long)Math.max(reactor.oNeutronCounts[slot] - tNeutronSelf, 0), (long)tNeutronDiv);
        return ItemNuclearFuelRod.bindInt(tEmission);
    }

    private static int bindInt(long aBoundValue) {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, aBoundValue));
    }

    @Override
    public boolean getReactorRodNeutronReaction(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        boolean oModerated;
        reactor.heatHandler.ifPresent(h -> h.insertInternal(reactor.oNeutronCounts[slot], false));
        FluidStack coldCoolant = reactor.fluidHandler.map(f -> f.getInputTanks().getFluidInTank(0)).orElse(FluidStack.EMPTY);
        int tNeutronMax = this.getReactorRodNeutronMaximum(reactor, slot, stack);
        if (coldCoolant.getFluid().m_205067_(Materials.DistilledWater.getFluidTag()) || coldCoolant.getFluid().m_205067_(Materials.SemiheavyWater.getFluidTag()) || coldCoolant.getFluid().m_205067_(Materials.HeavyWater.getFluidTag()) || coldCoolant.getFluid().m_205067_(Materials.TritiatedWater.getFluidTag())) {
            stack.m_41784_().m_128379_("moderated", true);
            stack.m_41784_().m_128379_("oldModerated", true);
        }
        long durabilityLoss = reactor.oNeutronCounts[slot] < tNeutronMax ? 100L : CodeUtils.divup((long)(400 * reactor.oNeutronCounts[slot]), (long)tNeutronMax);
        boolean bl = oModerated = stack.m_41783_() != null && stack.m_41783_().m_128471_("oldModerated");
        if (oModerated) {
            durabilityLoss *= 4L;
        }
        long durability = stack.m_41783_() != null && stack.m_41783_().m_128441_("rodDurability") ? stack.m_41783_().m_128454_("rodDurability") : this.durability;
        durability = durabilityLoss > durability ? -1L : durability - durabilityLoss;
        stack.m_41784_().m_128356_("rodDurability", durability);
        if (durability <= 0L) {
            ItemDepletedRod depletedRod = (ItemDepletedRod)GTAPI.get(ItemDepletedRod.class, (String)(this.material.getId() + "_depleted_rod"), (String)this.getDomain());
            if (depletedRod != null) {
                reactor.setRod(slot, new ItemStack((ItemLike)depletedRod));
            } else {
                stack.m_41764_(0);
            }
        }
        return true;
    }

    @Override
    public int getReactorRodNeutronReflection(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack, int neutrons, boolean moderated) {
        if (moderated) {
            stack.m_41784_().m_128379_("moderated", true);
        }
        int n = slot;
        reactor.mNeutronCounts[n] = reactor.mNeutronCounts[n] + neutrons;
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        FluidStack coldCoolant = reactor.fluidHandler.map(f -> f.getInputTanks().getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (coldCoolant.getFluid().m_205067_(Materials.LithiumChloride.getFluidTag())) {
            return (int)((long)this.maximum * CodeUtils.divup((long)this.maximum, (long)4L));
        }
        if (coldCoolant.getFluid().m_205067_(Materials.ThoriumSalt.getFluidTag())) {
            return this.maximum * 4;
        }
        if (coldCoolant.getFluid().m_205067_(Materials.HeavyWater.getFluidTag())) {
            return (int)CodeUtils.divup((long)this.maximum, (long)8L);
        }
        if (coldCoolant.getFluid().m_205067_(Materials.TritiatedWater.getFluidTag())) {
            return (int)CodeUtils.divup((long)this.maximum, (long)16L);
        }
        return this.maximum;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }
}

