/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.xei;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;

public record OreByProduct(Material material, BathingMode bathingMode) {
    public Material getMacerateInto() {
        return MaterialTags.MACERATE_INTO.getMapping(this.material);
    }

    public Material getByproduct(int index) {
        if (this.material.getByProducts().isEmpty()) {
            return this.getMacerateInto();
        }
        if (this.material.getByProducts().size() <= index) {
            return (Material)this.material.getByProducts().get(this.material.getByProducts().size() - 1);
        }
        return (Material)this.material.getByProducts().get(index);
    }

    public Material getThermalByproduct() {
        if (this.material.has(new IMaterialTag[]{GT5RMaterialTags.THERMAL_CENTRIFUGE_EXPLICIT})) {
            return GT5RMaterialTags.THERMAL_CENTRIFUGE_EXPLICIT.getMapping(this.material);
        }
        return this.getByproduct(1);
    }

    public boolean hasSiftingRecipe() {
        return this.material.has(new IMaterialTag[]{GTMaterialTypes.GEM});
    }

    public boolean hasSepRecipes() {
        return this.material.has(new IMaterialTag[]{GT5RMaterialTags.ELECSEPI}) || this.material.has(new IMaterialTag[]{GT5RMaterialTags.ELECSEPG}) || this.material.has(new IMaterialTag[]{GT5RMaterialTags.ELECSEPN});
    }

    public boolean hasFurnaceSmeltingRecipe() {
        return !this.material.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE}) && (MaterialTags.SMELT_INTO.getMapping(this.material).has(new IMaterialTag[]{GTMaterialTypes.INGOT}) || MaterialTags.SMELT_INTO.getMapping(this.material).has(new IMaterialTag[]{GTMaterialTypes.GEM}));
    }

    public List<SlotResult> getSlots() {
        ArrayList<SlotResult> slots = new ArrayList<SlotResult>(this.getMainSlots());
        if (this.hasFurnaceSmeltingRecipe()) {
            slots.addAll(this.getSmeltSlots());
        }
        if (this.bathingMode != BathingMode.NONE) {
            slots.addAll(this.getBathSlots());
        }
        if (this.hasSiftingRecipe()) {
            slots.addAll(this.getSiftSlots());
        }
        if (this.hasSepRecipes()) {
            slots.addAll(this.getSepSlots());
        }
        return slots;
    }

    public List<Triple<Integer, Integer, Integer>> getChanceOverlays() {
        ArrayList<Triple<Integer, Integer, Integer>> overlays = new ArrayList<Triple<Integer, Integer, Integer>>(List.of(Triple.of((Object)1, (Object)63, (Object)1000), Triple.of((Object)22, (Object)108, (Object)1000), Triple.of((Object)163, (Object)45, (Object)1000), Triple.of((Object)69, (Object)117, (Object)1000)));
        if (this.material.getByProducts().size() > 3) {
            overlays.add((Triple)Triple.of((Object)87, (Object)99, (Object)1000));
        }
        if (this.material.getByProducts().size() > 4) {
            overlays.add((Triple)Triple.of((Object)87, (Object)117, (Object)1000));
        }
        if (this.bathingMode != BathingMode.NONE) {
            overlays.add((Triple<Integer, Integer, Integer>)Triple.of((Object)87, (Object)45, (Object)7000));
        }
        if (this.hasSiftingRecipe()) {
            boolean e = this.material.has(new IMaterialTag[]{GTMaterialTypes.EXQUISITE_GEM});
            overlays.addAll(List.of(Triple.of((Object)127, (Object)1, (Object)(e ? 300 : 100)), Triple.of((Object)145, (Object)1, (Object)(e ? 1200 : 400)), Triple.of((Object)163, (Object)1, (Object)(e ? 4500 : 1500)), Triple.of((Object)127, (Object)19, (Object)(e ? 1400 : 2000)), Triple.of((Object)145, (Object)19, (Object)(e ? 2800 : 4000)), Triple.of((Object)163, (Object)19, (Object)(e ? 3500 : 5000))));
        }
        if (this.hasSepRecipes()) {
            overlays.add((Triple<Integer, Integer, Integer>)Triple.of((Object)163, (Object)108, (Object)4000));
            overlays.add((Triple<Integer, Integer, Integer>)Triple.of((Object)163, (Object)126, (Object)2000));
        }
        return overlays;
    }

    public List<SlotResult> getMainSlots() {
        ArrayList<SlotResult> slots = new ArrayList<SlotResult>(List.of(this.mch(1, 23, (Machine<?>)GT5RMachines.MACERATOR), this.createOutput(1, 45, GTMaterialTypes.CRUSHED_ORE, this.getMacerateInto(), 2 * (Integer)MaterialTags.ORE_MULTI.get(this.material)), this.createOutput(1, 63, GTMaterialTypes.DUST, this.getByproduct(0), 1, 1000), this.mch(22, 69, (Machine<?>)GT5RMachines.MACERATOR), this.createOutput(22, 90, GTMaterialTypes.IMPURE_DUST, this.getMacerateInto(), 1), this.createOutput(22, 108, GTMaterialTypes.DUST, this.getByproduct(0), 1, 1000), this.mch(26, 23, (Machine<?>)GT5RMachines.ORE_WASHER), new SlotResult(47, 23, true, List.of(Materials.Water.getLiquid(1000))), this.createOutput(69, 23, GTMaterialTypes.PURIFIED_ORE, this.getMacerateInto(), 1), this.createOutput(87, 23, GTMaterialTypes.TINY_DUST, this.getByproduct(0), 1), this.mch(117, 45, (Machine<?>)GT5RMachines.MACERATOR), this.createOutput(145, 45, GTMaterialTypes.PURE_DUST, this.getMacerateInto(), 1), this.createOutput(163, 45, GTMaterialTypes.DUST, this.getByproduct(1), 1, 1000), this.mch(123, 69, (Machine<?>)GT5RMachines.THERMAL_CENTRIFUGE), this.createOutput(123, 90, GTMaterialTypes.REFINED_ORE, this.getMacerateInto(), 1), this.createOutput(123, 108, GTMaterialTypes.TINY_DUST, this.getThermalByproduct(), 1), this.mch(145, 69, (Machine<?>)GT5RMachines.CENTRIFUGE), this.createOutput(145, 90, GTMaterialTypes.DUST, this.getMacerateInto(), 1), this.createOutput(145, 108, GTMaterialTypes.TINY_DUST, this.getByproduct(1), 1), this.mch(47, 78, (Machine<?>)GT5RMachines.CENTRIFUGE), this.createOutput(47, 99, GTMaterialTypes.DUST, this.getMacerateInto(), 1), this.createOutput(47, 117, GTMaterialTypes.TINY_DUST, this.getByproduct(0), 1), this.mch(69, 78, (Machine<?>)GT5RMachines.MACERATOR), this.createOutput(69, 99, GTMaterialTypes.DUST, this.getMacerateInto(), 1), this.createOutput(69, 117, GTMaterialTypes.DUST, this.getByproduct(2), 1, 1000), this.createOutput(1, 103, GTMaterialTypes.CRUSHED_ORE, this.getMacerateInto(), 1), new SlotResult(1, 122, List.of(new ItemStack((ItemLike)Items.f_42544_), new ItemStack((ItemLike)GT5RMachines.ORE_WASHER.getItem(Tier.LV))), true), this.createOutput(1, 143, GTMaterialTypes.PURIFIED_ORE, this.getMacerateInto(), 1), this.createOutput(22, 143, GTMaterialTypes.IMPURE_DUST, this.getMacerateInto(), 1), new SlotResult(40, 143, List.of(new ItemStack((ItemLike)Items.f_42544_), new ItemStack((ItemLike)GT5RMachines.CENTRIFUGE.getItem(Tier.LV))), true), this.createOutput(62, 143, GTMaterialTypes.DUST, this.getMacerateInto(), 1), this.createOutput(83, 143, GTMaterialTypes.PURE_DUST, this.getMacerateInto(), 1), new SlotResult(101, 143, List.of(new ItemStack((ItemLike)Items.f_42544_), new ItemStack((ItemLike)GT5RMachines.CENTRIFUGE.getItem(Tier.LV))), true), this.createOutput(123, 143, GTMaterialTypes.DUST, this.getMacerateInto(), 1)));
        if (this.material.getByProducts().size() > 3) {
            slots.add(this.createOutput(87, 99, GTMaterialTypes.DUST, this.getByproduct(3), 1, 1000));
        }
        if (this.material.getByProducts().size() > 4) {
            slots.add(this.createOutput(87, 117, GTMaterialTypes.DUST, this.getByproduct(4), 1, 1000));
        }
        return slots;
    }

    private List<SlotResult> getSmeltSlots() {
        return List.of(new SlotResult(26, 1, List.of(new ItemStack((ItemLike)Items.f_41962_), new ItemStack((ItemLike)Items.f_42770_)), true), this.createOutput(47, 1, ((Material)MaterialTags.SMELT_INTO.get(this.material)).has(new IMaterialTag[]{GTMaterialTypes.GEM}) ? GTMaterialTypes.GEM : GTMaterialTypes.INGOT, (Material)MaterialTags.SMELT_INTO.get(this.material), MaterialTags.SMELTING_MULTI.getInt(this.material)));
    }

    private List<SlotResult> getBathSlots() {
        Material bathOutput = this.bathingMode == BathingMode.MERCURY ? GT5RMaterialTags.BATH_MERCURY.getMapping(this.material) : GT5RMaterialTags.BATH_PERSULFATE.getMapping(this.material);
        Material fluidOutput = this.bathingMode == BathingMode.MERCURY ? Materials.Mercury : Materials.SodiumPersulfateSolution;
        return List.of(this.mch(26, 45, (Machine<?>)GT5RMachines.BATH), new SlotResult(47, 45, true, List.of(fluidOutput.getLiquid(1000))), this.createOutput(87, 45, GTMaterialTypes.DUST, bathOutput, 1, 7000), this.createOutput(69, 45, GTMaterialTypes.PURIFIED_ORE, this.getMacerateInto(), 1));
    }

    private List<SlotResult> getSiftSlots() {
        boolean e = this.material.has(new IMaterialTag[]{GTMaterialTypes.EXQUISITE_GEM});
        return List.of(this.mch(107, 22, (Machine<?>)GT5RMachines.SIFTER), this.createOutput(127, 1, e ? GTMaterialTypes.EXQUISITE_GEM : GTMaterialTypes.GEM, this.getMacerateInto(), 1, e ? 300 : 100), this.createOutput(145, 1, e ? GTMaterialTypes.FLAWLESS_GEM : GTMaterialTypes.GEM, this.getMacerateInto(), 1, e ? 1200 : 400), this.createOutput(163, 1, GTMaterialTypes.GEM, this.getMacerateInto(), 1, e ? 4500 : 1500), this.createOutput(127, 19, e ? GTMaterialTypes.FLAWED_GEM : GTMaterialTypes.GEM, this.getMacerateInto(), 1, e ? 1400 : 2000), this.createOutput(145, 19, e ? GTMaterialTypes.CHIPPED_GEM : GTMaterialTypes.GEM, this.getMacerateInto(), 1, e ? 2800 : 4000), this.createOutput(163, 19, GTMaterialTypes.DUST, this.getMacerateInto(), 1, e ? 3500 : 5000));
    }

    private List<SlotResult> getSepSlots() {
        Material byProduct = this.material.has(new IMaterialTag[]{GT5RMaterialTags.ELECSEPI}) ? Materials.Iron : (this.material.has(new IMaterialTag[]{GT5RMaterialTags.ELECSEPG}) ? Materials.Gold : Materials.Neodymium);
        return List.of(this.mch(163, 69, (Machine<?>)GT5RMachines.ELECTROMAGNETIC_SEPARATOR), this.createOutput(163, 90, GTMaterialTypes.DUST, this.getMacerateInto(), 1), this.createOutput(163, 108, GTMaterialTypes.SMALL_DUST, byProduct, 2, 4000), this.createOutput(163, 126, GTMaterialTypes.NUGGET, byProduct, 1, 2000));
    }

    private SlotResult mch(int x, int y, Machine<?> machine) {
        return new SlotResult(x, y, List.of(new ItemStack((ItemLike)machine.getItem(machine.getFirstTier()))), true);
    }

    private SlotResult createOutput(int x, int y, MaterialTypeItem<?> outputType, Material material, int amount) {
        return new SlotResult(x, y, List.of(outputType.get(material, amount)), false);
    }

    private SlotResult createOutput(int x, int y, MaterialTypeItem<?> outputType, Material material, int amount, int chance) {
        return new SlotResult(x, y, List.of(outputType.get(material, amount)), false, chance);
    }

    public static enum BathingMode {
        NONE,
        MERCURY,
        PERSULFATE;

    }

    public record SlotResult(int x, int y, List<ItemStack> stacks, List<FluidStack> fluidStacks, boolean input, int chance) {
        public SlotResult(int x, int y, List<ItemStack> stacks, boolean input) {
            this(x, y, stacks, List.of(), input, -1);
        }

        public SlotResult(int x, int y, List<ItemStack> stacks, boolean input, int chance) {
            this(x, y, stacks, List.of(), input, chance);
        }

        public SlotResult(int x, int y, boolean input, List<FluidStack> fluidStacks) {
            this(x, y, List.of(), fluidStacks, input, -1);
        }
    }

    public static enum SepMode {
        NONE,
        IRON,
        GOLD,
        NEODYMIUM;

    }
}

