/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.recipes;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.tfc.Metals;
import org.gtreimagined.gt5r.integration.tfc.data.TFCMaterialTypes;
import org.gtreimagined.gt5r.integration.tfc.data.TFCToolTypes;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.AnvilWorkingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.CastingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.HeatingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.WeldingFinishedRecipe;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class MetalRecipes {
    private static final Map<MaterialTypeItem<?>, List<String>> FORGING_RULES = new Object2ObjectOpenHashMap();

    public static void init(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        List<Material> chains = List.of(Materials.BismuthBronze, Materials.BlackBronze, Materials.Bronze, Materials.Copper, Materials.WroughtIron, Materials.Steel, Materials.BlackSteel, Materials.BlueSteel, Materials.RedSteel);
        Metals.METALS.forEach((m, i) -> {
            MaterialTypeItem[] types;
            boolean tfc;
            int meltTemp = (Integer)MaterialTags.MELTING_POINT.get(m) - 273;
            boolean magnetic = m == Materials.IronMagnetic || m == Materials.SteelMagnetic;
            boolean bl = tfc = (Boolean)i.m_14418_() != false || magnetic;
            String fluidId = m == Materials.WroughtIron || m == Materials.IronMagnetic ? "cast_iron" : (m == Materials.SteelMagnetic ? "steel" : m.getId());
            Function<Integer, FluidStack> fluid = amount -> new FluidStack(RegistryUtils.getFluidFromID((ResourceLocation)new ResourceLocation(tfc ? "tfc" : "antimatter_shared", (tfc ? "metal/" : "") + fluidId)), amount.intValue());
            if (m.has(new IMaterialTag[]{MaterialTags.TOOLS})) {
                GTToolType[] toolTypes = new GTToolType[]{GTTools.SWORD, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.AXE, GTTools.HOE, GTTools.HAMMER, GTTools.SAW, GTTools.FILE, GTTools.SCREWDRIVER, GTTools.KNIFE, GTTools.SCYTHE, TFCToolTypes.PROPICK, TFCToolTypes.JAVELIN};
                ToolData t = (ToolData)MaterialTags.TOOLS.get(m);
                GTToolType[] gTToolTypeArray = toolTypes;
                int n = gTToolTypeArray.length;
                for (int j = 0; j < n; ++j) {
                    GTToolType toolType = gTToolTypeArray[j];
                    if (toolType.getReplacements().containsKey(m.getId()) || !t.toolTypes().contains(toolType)) continue;
                    MaterialTypeItem toolHead = toolType.getMaterialTypeItem();
                    if (toolType == GTTools.SCREWDRIVER && !m.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD})) continue;
                    double ratio = (double)toolHead.getUnitValue() / 1.8144E7;
                    consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("gt5r", "heating/" + m.getId() + "_" + toolType.getId()), Ingredient.m_43929_((ItemLike[])new ItemLike[]{toolType.getToolItem(m)}), fluid.apply((int)(ratio * 100.0)), meltTemp));
                    consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("gt5r", "heating/" + m.getId() + "_" + toolHead.getId()), Ingredient.m_204132_((TagKey)toolType.getMaterialTypeItem().getMaterialTag(m)), fluid.apply((int)(ratio * 100.0)), meltTemp));
                    if (!magnetic && toolType != GTTools.FILE && toolType != GTTools.SCREWDRIVER) {
                        consumer.accept(new CastingFinishedRecipe(new ResourceLocation("gt5r", "casting/" + m.getId() + "_" + toolHead.getId()), RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation("tfc", "ceramic/" + toolHead.getId() + "_mold")), fluid.apply((int)(ratio * 100.0)), toolHead.get(m), 1.0f));
                    }
                    if (toolHead.getUnitValue() != 18144000L && toolHead.getUnitValue() != 36288000L) continue;
                    MaterialTypeItem<?> input = toolHead == GTMaterialTypes.SCREWDRIVER_TIP ? GTMaterialTypes.LONG_ROD : (toolHead.getUnitValue() == 18144000L ? GTMaterialTypes.INGOT : TFCMaterialTypes.DOUBLE_INGOT);
                    consumer.accept(new AnvilWorkingFinishedRecipe(new ResourceLocation("gt5r", "anvil/" + m.getId() + "_" + toolHead.getId()), (Ingredient)input.getMaterialIngredient(m, 1), toolHead.get(m, 1), (Integer)i.m_14419_(), true, (String[])FORGING_RULES.get(toolHead).toArray(String[]::new)));
                }
            }
            for (MaterialTypeItem type : types = new MaterialTypeItem[]{GTMaterialTypes.RAW_ORE, GTMaterialTypes.BEARING_ROCK, GTMaterialTypes.INGOT, TFCMaterialTypes.DOUBLE_INGOT, TFCMaterialTypes.SHEET, GTMaterialTypes.PLATE, GTMaterialTypes.ROD, GTMaterialTypes.LONG_ROD, GTMaterialTypes.RING, GTMaterialTypes.CHUNK, GTMaterialTypes.DUST}) {
                int amount2;
                if (!m.has(new IMaterialTag[]{type}) || type.hasReplacement(m)) continue;
                double ratio = type == GTMaterialTypes.RAW_ORE ? 0.5 : (type == GTMaterialTypes.BEARING_ROCK ? 0.1 : (double)type.getUnitValue() / 1.8144E7);
                consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("gt5r", "heating/" + m.getId() + "_" + type.getId()), Ingredient.m_204132_((TagKey)type.getMaterialTag(m)), fluid.apply((int)(100.0 * ratio)), meltTemp));
                if (!magnetic && type == GTMaterialTypes.INGOT) {
                    consumer.accept(new CastingFinishedRecipe(new ResourceLocation("gt5r", "casting/" + m.getId() + "_ingot"), (Item)((RegistryObject)TFCItems.MOLDS.get(Metal.ItemType.INGOT)).get(), fluid.apply(100), GTMaterialTypes.INGOT.get(m), 0.1f));
                    consumer.accept(new CastingFinishedRecipe(new ResourceLocation("gt5r", "casting/" + m.getId() + "_fire_ingot"), (Item)TFCItems.FIRE_INGOT_MOLD.get(), fluid.apply(100), GTMaterialTypes.INGOT.get(m), 0.01f));
                }
                if (type != TFCMaterialTypes.SHEET && type != GTMaterialTypes.ROD && type != GTMaterialTypes.RING) continue;
                int n = amount2 = type == GTMaterialTypes.ROD || type == GTMaterialTypes.RING ? 2 : 1;
                MaterialTypeItem<?> in = type == GTMaterialTypes.ROD ? GTMaterialTypes.INGOT : (type == GTMaterialTypes.RING ? GTMaterialTypes.ROD : TFCMaterialTypes.DOUBLE_INGOT);
                consumer.accept(new AnvilWorkingFinishedRecipe(new ResourceLocation("gt5r", "anvil/" + m.getId() + "_" + type.getId()), (Ingredient)in.getMaterialIngredient(m, 1), type.get(m, amount2), (Integer)i.m_14419_(), false, (String[])FORGING_RULES.get(type).toArray(String[]::new)));
            }
            if (!TFCMaterialTypes.DOUBLE_INGOT.hasReplacement(m)) {
                consumer.accept(new WeldingFinishedRecipe(new ResourceLocation("gt5r", "welding/" + m.getId() + "_double_ingot"), (Ingredient)GTMaterialTypes.INGOT.getMaterialIngredient(m, 1), (Ingredient)GTMaterialTypes.INGOT.getMaterialIngredient(m, 1), TFCMaterialTypes.DOUBLE_INGOT.get(m, 1), (Integer)i.m_14419_()));
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.ROD}) && m.has(new IMaterialTag[]{GTMaterialTypes.LONG_ROD})) {
                consumer.accept(new WeldingFinishedRecipe(new ResourceLocation("gt5r", "welding/" + m.getId() + "_long_rod"), (Ingredient)GTMaterialTypes.ROD.getMaterialIngredient(m, 1), (Ingredient)GTMaterialTypes.ROD.getMaterialIngredient(m, 1), GTMaterialTypes.LONG_ROD.get(m, 1), (Integer)i.m_14419_()));
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RING}) && chains.contains(m)) {
                consumer.accept(new WeldingFinishedRecipe(new ResourceLocation("gt5r", "welding/" + m.getId() + "_chain"), (Ingredient)GTMaterialTypes.RING.getMaterialIngredient(m, 1), (Ingredient)GTMaterialTypes.RING.getMaterialIngredient(m, 1), new ItemStack((ItemLike)RegistryUtils.getItemFromID((String)"tfc", (String)("metal/chain/" + m.getId()))), (Integer)i.m_14419_()));
            }
        });
        for (Material chain : chains) {
            String fluidId = chain == Materials.WroughtIron ? "cast_iron" : chain.getId();
            int meltTemp = (Integer)MaterialTags.MELTING_POINT.get(chain) - 273;
            consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("tfc", "heating/metal/" + chain.getId() + "_chain"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{RegistryUtils.getItemFromID((String)"tfc", (String)("metal/chain/" + chain.getId()))}), new FluidStack(RegistryUtils.getFluidFromID((ResourceLocation)new ResourceLocation("tfc", "metal/" + fluidId)), 50), meltTemp));
            provider.removeRecipe(new ResourceLocation("tfc", "anvil/" + chain.getId() + "_chain"));
        }
    }

    static {
        FORGING_RULES.put(GTMaterialTypes.SWORD_BLADE, List.of("hit_last", "bend_second_last", "bend_third_last"));
        FORGING_RULES.put(GTMaterialTypes.PICKAXE_HEAD, List.of("punch_last", "bend_not_last", "draw_not_last"));
        FORGING_RULES.put(GTMaterialTypes.SHOVEL_HEAD, List.of("punch_last", "hit_not_last"));
        FORGING_RULES.put(GTMaterialTypes.AXE_HEAD, List.of("punch_last", "hit_second_last", "upset_third_last"));
        FORGING_RULES.put(GTMaterialTypes.HOE_HEAD, List.of("punch_last", "hit_not_last", "bend_not_last"));
        FORGING_RULES.put(GTMaterialTypes.HAMMER_HEAD, List.of("punch_last", "shrink_not_last"));
        FORGING_RULES.put(GTMaterialTypes.SAW_BLADE, List.of("hit_last", "hit_second_last"));
        FORGING_RULES.put(GTMaterialTypes.FILE_HEAD, List.of("hit_last", "punch_second_last"));
        FORGING_RULES.put(GTMaterialTypes.KNIFE_BLADE, List.of("hit_last", "draw_second_last", "draw_third_last"));
        FORGING_RULES.put(GTMaterialTypes.SCYTHE_BLADE, List.of("hit_last", "draw_second_last", "bend_third_last"));
        FORGING_RULES.put(GTMaterialTypes.SCREWDRIVER_TIP, List.of("hit_last", "hit_second_last", "hit_third_last"));
        FORGING_RULES.put(TFCMaterialTypes.PROPICK_HEAD, List.of("punch_last", "draw_not_last", "bend_not_last"));
        FORGING_RULES.put(TFCMaterialTypes.JAVELIN_HEAD, List.of("hit_last", "hit_second_last", "draw_third_last"));
        FORGING_RULES.put(TFCMaterialTypes.CHISEL_HEAD, List.of("hit_last", "hit_not_last", "draw_not_last"));
        FORGING_RULES.put(TFCMaterialTypes.MACE_HEAD, List.of("hit_last", "shrink_not_last", "bend_not_last"));
        FORGING_RULES.put(TFCMaterialTypes.SHEET, List.of("hit_last", "hit_second_last", "hit_third_last"));
        FORGING_RULES.put(GTMaterialTypes.ROD, List.of("bend_last", "draw_second_last", "draw_third_last"));
        FORGING_RULES.put(GTMaterialTypes.RING, List.of("hit_last", "bend_second_last", "bend_third_last"));
    }
}

