/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.items.JavelinItem;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.NonNullLazy;
import org.gtreimagined.gt5r.integration.tfc.client.GTJavelinItemRenderer;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialJavelin
extends JavelinItem
implements IGTTool {
    protected String domain;
    protected GTToolType type;
    protected GTItemTier itemTier;
    public static final ResourceLocation OVERLAY_LOCATION = new ResourceLocation("gt5r", "textures/entity/javelin_overlay.png");

    public MaterialJavelin(String domain, GTToolType type, GTItemTier tier, Item.Properties properties) {
        super((Tier)GTItemTier.NULL, 0.0f, type.getBaseAttackSpeed(), properties, new ResourceLocation("gt5r", "textures/entity/javelin.png"));
        this.domain = domain;
        this.type = type;
        this.itemTier = tier;
        GTAPI.register(IGTTool.class, (IGTObject)this);
    }

    public String getId() {
        if (this.type.isSimple()) {
            return String.join((CharSequence)"_", this.itemTier.getPrimary().getId(), this.type.getId());
        }
        return this.type.getId();
    }

    public String getDomain() {
        return this.domain;
    }

    @NotNull
    public GTToolType getGTToolType() {
        return this.type;
    }

    public GTItemTier getGTItemTier() {
        return this.itemTier;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<GTJavelinItemRenderer> renderer = NonNullLazy.of(() -> new GTJavelinItemRenderer(MaterialJavelin.this.getTextureLocation(), OVERLAY_LOCATION));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @NotNull
    public ItemStack asItemStack(@NotNull Material primary, @NotNull Material secondary) {
        return this.resolveStack(primary, secondary, 0L, 0L);
    }

    public int getEnergyTier() {
        return 0;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        this.onGenericFillItemGroup(group, list, 0L);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.type.getUseAction();
    }

    public int m_8105_(ItemStack stack) {
        return this.type.getUseAction() == UseAnim.NONE ? super.m_8105_(stack) : 72000;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getTier(stack).m_6609_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.onGenericHitEntity(stack, target, attacker, 0.75f, 0.75f);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onGenericItemUse(ctx);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return this.genericInteractLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder result = this.onGenericRightclick(level, player, usedHand);
        if (result.m_19089_().m_146666_()) {
            return result;
        }
        return super.m_7203_(level, player, usedHand);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.type.getToolTypes().contains(BlockTags.f_144280_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotType, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slotType == EquipmentSlot.MAINHAND) {
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.type.getBaseAttackDamage() + this.getTier(stack).m_6631_()), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.type.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return entity instanceof Player && ((Player)entity).m_7500_() ? 0 : this.damage(stack, amount);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return !this.type.isPowered() && this.getTier(toRepair).m_6282_().test(repair);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type.getBlacklistedEnchantments().contains(enchantment)) {
            return false;
        }
        return this.type.isPowered() ? enchantment != Enchantments.f_44986_ : enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.type.hasContainer();
    }

    public ItemStack getContainerItem(ItemStack oldStack) {
        return this.getGenericContainerItem(oldStack);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return null;
    }

    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        GTItemModelBuilder b = ((GTItemModelBuilder)prov.getBuilder(item).loader(new ResourceLocation("forge", "separate-perspective"))).override().model(new ResourceLocation("gt5r", "item/" + this.getId() + "_throwing")).predicate(new ResourceLocation("tfc", "throwing"), 1.0f).end().property("gui_light", "front");
        JsonObject base = new JsonObject();
        base.addProperty("parent", "gt5r:item/" + this.getId() + "_in_hand");
        JsonObject gui = new JsonObject();
        gui.addProperty("parent", "gt5r:item/" + this.getId() + "_gui");
        JsonObject perspectives = new JsonObject();
        perspectives.add("none", (JsonElement)gui);
        perspectives.add("fixed", (JsonElement)gui);
        perspectives.add("ground", (JsonElement)gui);
        perspectives.add("gui", (JsonElement)gui);
        b.property("base", (Object)base).property("perspectives", (Object)perspectives);
        GTItemModelBuilder builder = (GTItemModelBuilder)prov.getBuilder(this.getId() + "_gui");
        builder.parent(new ResourceLocation("item/generated"));
        for (int i = 0; i < this.getTextures().length; ++i) {
            builder.texture("layer" + i, (ResourceLocation)this.getTextures()[i]);
        }
        builder = (GTItemModelBuilder)prov.getBuilder(this.getId() + "_in_hand");
        builder.parent(new ResourceLocation("item/trident_in_hand"));
        builder.texture("particle", (ResourceLocation)this.getTextures()[0]);
        builder = (GTItemModelBuilder)prov.getBuilder(this.getId() + "_throwing_base");
        builder.parent(new ResourceLocation("item/trident_throwing"));
        builder.texture("particle", (ResourceLocation)this.getTextures()[0]);
        b = ((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(this.getId() + "_throwing")).loader(new ResourceLocation("forge", "separate-perspective"))).property("gui_light", "front");
        base = new JsonObject();
        base.addProperty("parent", "gt5r:item/" + this.getId() + "_throwing_base");
        b.property("base", (Object)base).property("perspectives", (Object)perspectives);
    }
}

