/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.datagen;

import java.util.Map;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.tfc.Metals;
import org.gtreimagined.gt5r.integration.tfc.data.TFCMaterialTypes;
import org.gtreimagined.gt5r.integration.tfc.data.TFCToolTypes;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemTagProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.TagUtils;

public class TFCItemTagProvider
extends GTItemTagProvider {
    public TFCItemTagProvider(String providerDomain, String providerName, boolean replace, GTBlockTagProvider p) {
        super(providerDomain, providerName, replace, p);
    }

    protected void processTags(String domain) {
        super.processTags(domain);
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "swords"))).addTag(GTTools.SWORD.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "pickaxes"))).addTag(GTTools.PICKAXE.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "shovels"))).addTag(GTTools.SHOVEL.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "axes"))).addTag(GTTools.AXE.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "hoes"))).addTag(GTTools.HOE.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "saws"))).addTag(GTTools.SAW.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "knives"))).addTag(GTTools.KNIFE.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "scythes"))).addTag(GTTools.SCYTHE.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "javelins"))).addTag(TFCToolTypes.JAVELIN.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "hammers"))).addTag(GTTools.HAMMER.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "propicks"))).addTag(TFCToolTypes.PROPICK.getTag());
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "rock_knapping"))).add((Object)Items.f_42484_);
        this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "flux"))).add((Object[])new Item[]{GTMaterialTypes.DUST.get(Materials.Limestone), GTMaterialTypes.DUST.get(Materials.Marble), GTMaterialTypes.DUST.get(Materials.Calcite)});
        for (Metal.Default metal : Metal.Default.values()) {
            if (!metal.hasTools()) continue;
            this.tag(GTTools.HAMMER.getTag()).add((Object)((Item)((RegistryObject)((Map)TFCItems.METAL_ITEMS.get(metal)).get(Metal.ItemType.HAMMER)).get()));
            this.tag(GTTools.SAW.getTag()).add((Object)((Item)((RegistryObject)((Map)TFCItems.METAL_ITEMS.get(metal)).get(Metal.ItemType.SAW)).get()));
        }
        Material[] tfcTools = new Material[]{Materials.BismuthBronze, Materials.BlackBronze, Materials.Bronze, Materials.Copper, Materials.WroughtIron, Materials.Steel, Materials.BlackSteel, Materials.BlueSteel, Materials.RedSteel};
        GTMaterialTypes.INGOT.all().stream().filter(m -> !GTMaterialTypes.INGOT.hasReplacement(m) && Metals.METALS.containsKey(m)).forEach(m -> this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "pileable_ingots"))).add((Object)GTMaterialTypes.INGOT.get(m)));
        TFCMaterialTypes.SHEET.all().stream().filter(m -> !TFCMaterialTypes.SHEET.hasReplacement(m)).forEach(m -> this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "pileable_sheets"))).add((Object)TFCMaterialTypes.SHEET.get(m)));
        GTAPI.all(GTToolType.class).forEach(t -> {
            if (t.hasOriginalTag()) {
                this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "usable_on_tool_rack"))).addTag(t.getTag());
            }
            if (!t.isSimple()) {
                return;
            }
            for (Material tfcTool : tfcTools) {
                ToolData data = (ToolData)MaterialTags.TOOLS.get(tfcTool);
                if (data == null || !data.toolTypes().contains(t)) continue;
                this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "metal_item/" + tfcTool.getId() + "_tools"))).add((Object)t.getToolItem(tfcTool));
                this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "metal_item/" + tfcTool.getId()))).add((Object)t.getToolItem(tfcTool));
                if (t != GTTools.AXE && t != GTTools.SWORD) continue;
                this.tag(TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "mob_mainhand_weapons"))).add((Object)t.getToolItem(tfcTool));
            }
        });
    }
}

