/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.tfc.data.TFCMaterialTypes;
import org.gtreimagined.gt5r.integration.tfc.data.TFCToolTypes;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.tool.GTToolType;

public class Metals {
    public static final Object2ObjectMap<Material, Tuple<Boolean, Integer>> METALS = new Object2ObjectOpenHashMap();

    public static void init() {
        Metals.addMetalFromMaterial(Materials.Aluminium, 3, 0.1, 3.333);
        Metals.addMetalFromMaterial(Materials.Antimony, 1, 0.012, 4.0);
        Metals.addMetalFromMaterial(Materials.Beryllium, 3);
        Metals.addMetalFromMaterial(Materials.Lead, 1, 0.01364, 4.545);
        Metals.addMetalFromMaterial(Materials.BatteryAlloy, 1, 0.013312, 4.436);
        Metals.addMetalFromMaterial(Materials.Cupronickel, 2, 0.00741, 2.47);
        Metals.addMetalFromMaterial(Materials.DamascusSteel, 4);
        Metals.addMetalFromMaterial(Materials.Electrum, 2, 0.005625, 1.875);
        Metals.addMetalFromMaterial(Materials.Invar, 3);
        Metals.addHeatableToolFromTFCMetal(Materials.RoseGold, 1, 960, 2.857, false);
        Metals.addHeatableToolFromTFCMetal(Materials.SterlingSilver, 1, 950, 2.857, false);
        Metals.addHeatableToolFromTFCMetal(Materials.BismuthBronze, 2, 985, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.Bronze, 2, 950, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.BlackBronze, 2, 1070, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.WroughtIron, 3, 1535, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.Steel, 4, 1540, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.BlackSteel, 5, 1485, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.BlueSteel, 6, 1540, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.RedSteel, 6, 1540, 2.857, true);
        Metals.addHeatableToolFromTFCMetal(Materials.Bismuth, 1, 270, 7.143, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Brass, 2, 930, 2.857, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Copper, 1, 1080, 2.857, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Gold, 1, 1060, 1.667, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Nickel, 1, 1453, 2.083, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Silver, 1, 961, 2.083, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Tin, 1, 230, 7.143, false);
        Metals.addHeatableToolFromTFCMetal(Materials.Zinc, 1, 420, 4.762, false);
    }

    private static void addMetalFromMaterial(Material material, int tier) {
        Metals.addMetalFromMaterial(material, tier, 0.00857, 2.857);
    }

    private static void addHeatableToolFromTFCMetal(Material material, int tier, int meltTemp, double heatCapacityForHeating, boolean fileOnly) {
        METALS.put((Object)material, (Object)new Tuple((Object)true, (Object)tier));
        MaterialTypeItem[] types = new MaterialTypeItem[]{GTMaterialTypes.RAW_ORE, GTMaterialTypes.BEARING_ROCK, GTMaterialTypes.PLATE, GTMaterialTypes.CHUNK, GTMaterialTypes.LONG_ROD, GTMaterialTypes.RING, GTMaterialTypes.DUST};
        Arrays.stream(types).forEach(t -> {
            if (!material.has(new IMaterialTag[]{t})) {
                return;
            }
            JsonObject j = new JsonObject();
            JsonObject ingrediient = new JsonObject();
            ingrediient.addProperty("tag", t.getMaterialTag(material).f_203868_().toString());
            j.add("ingredient", (JsonElement)ingrediient);
            double ratio = t.getUnitValue() == -1L ? 1.0 : (double)t.getUnitValue() / 1.8144E7;
            j.addProperty("heat_capacity", (Number)(heatCapacityForHeating * ratio));
            j.addProperty("forging_temperature", (Number)((double)meltTemp * 0.6));
            j.addProperty("welding_temperature", (Number)((double)meltTemp * 0.8));
            GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + t.getId() + ".json"), j.toString().getBytes());
        });
        if (material.has(new IMaterialTag[]{MaterialTags.TOOLS})) {
            GTToolType[] toolTypes;
            ToolData td = (ToolData)MaterialTags.TOOLS.get(material);
            for (GTToolType toolType : toolTypes = new GTToolType[]{GTTools.SWORD, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.AXE, GTTools.HOE, GTTools.HAMMER, GTTools.SAW, GTTools.FILE, GTTools.SCREWDRIVER, GTTools.KNIFE, GTTools.SCYTHE, TFCToolTypes.PROPICK, TFCToolTypes.JAVELIN}) {
                if (fileOnly && toolType != GTTools.FILE && toolType != GTTools.SCREWDRIVER || !td.toolTypes().contains(toolType) || toolType.getMaterialTypeItem() == null) continue;
                MaterialTypeItem toolHead = toolType.getMaterialTypeItem();
                JsonObject j = new JsonObject();
                double ratio = (double)toolHead.getUnitValue() / 1.8144E7;
                j.addProperty("heat_capacity", (Number)(heatCapacityForHeating * ratio));
                j.addProperty("forging_temperature", (Number)((double)meltTemp * 0.6));
                j.addProperty("welding_temperature", (Number)((double)meltTemp * 0.8));
                JsonObject ingrediient = new JsonObject();
                ingrediient.addProperty("tag", toolHead.getMaterialTag(material).f_203868_().toString());
                j.add("ingredient", (JsonElement)ingrediient);
                GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + toolHead.getId() + ".json"), j.toString().getBytes());
                ingrediient = new JsonObject();
                ingrediient.addProperty("item", toolType.getDomain() + ":" + material.getId() + "_" + toolType.getId());
                j.add("ingredient", (JsonElement)ingrediient);
                GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + toolType.getId() + ".json"), j.toString().getBytes());
            }
        }
    }

    private static void addMetalFromMaterial(Material material, int tier, double specificHeatCapacity, double heatCapacityForHeating) {
        METALS.put((Object)material, (Object)new Tuple((Object)false, (Object)tier));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tier", (Number)tier);
        jsonObject.addProperty("fluid", "antimatter_shared:" + material.getId());
        int meltTemp = (Integer)MaterialTags.MELTING_POINT.get(material) - 273;
        jsonObject.addProperty("melt_temperature", (Number)meltTemp);
        jsonObject.addProperty("specific_heat_capacity", (Number)specificHeatCapacity);
        JsonObject object = new JsonObject();
        object.addProperty("tag", GTMaterialTypes.INGOT.getMaterialTag(material).f_203868_().toString());
        jsonObject.add("ingots", (JsonElement)object);
        object = new JsonObject();
        object.addProperty("tag", TFCMaterialTypes.SHEET.getMaterialTag(material).f_203868_().toString());
        jsonObject.add("sheets", (JsonElement)object);
        GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/metals/" + material.getId() + ".json"), jsonObject.toString().getBytes());
        MaterialTypeItem[] types = new MaterialTypeItem[]{GTMaterialTypes.RAW_ORE, GTMaterialTypes.BEARING_ROCK, GTMaterialTypes.INGOT, TFCMaterialTypes.DOUBLE_INGOT, TFCMaterialTypes.SHEET, GTMaterialTypes.PLATE, GTMaterialTypes.ROD, GTMaterialTypes.LONG_ROD, GTMaterialTypes.RING, GTMaterialTypes.CHUNK, GTMaterialTypes.DUST};
        Arrays.stream(types).forEach(t -> {
            MaterialTypeItem compare = t;
            if (t == TFCMaterialTypes.DOUBLE_INGOT || t == TFCMaterialTypes.SHEET) {
                compare = GTMaterialTypes.INGOT;
            }
            if (!material.has(new IMaterialTag[]{compare})) {
                return;
            }
            JsonObject j = new JsonObject();
            JsonObject ingrediient = new JsonObject();
            ingrediient.addProperty("tag", t.getMaterialTag(material).f_203868_().toString());
            j.add("ingredient", (JsonElement)ingrediient);
            double ratio = t.getUnitValue() == -1L ? 1.0 : (double)t.getUnitValue() / 1.8144E7;
            j.addProperty("heat_capacity", (Number)(heatCapacityForHeating * ratio));
            j.addProperty("forging_temperature", (Number)((double)meltTemp * 0.6));
            j.addProperty("welding_temperature", (Number)((double)meltTemp * 0.8));
            GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + t.getId() + ".json"), j.toString().getBytes());
        });
        if (material.has(new IMaterialTag[]{MaterialTags.TOOLS})) {
            GTToolType[] toolTypes;
            ToolData td = (ToolData)MaterialTags.TOOLS.get(material);
            for (GTToolType toolType : toolTypes = new GTToolType[]{GTTools.SWORD, GTTools.PICKAXE, GTTools.SHOVEL, GTTools.AXE, GTTools.HOE, GTTools.HAMMER, GTTools.SAW, GTTools.FILE, GTTools.SCREWDRIVER, GTTools.KNIFE, GTTools.SCYTHE, TFCToolTypes.PROPICK, TFCToolTypes.JAVELIN}) {
                if (!td.toolTypes().contains(toolType) || toolType.getMaterialTypeItem() == null) continue;
                MaterialTypeItem toolHead = toolType.getMaterialTypeItem();
                JsonObject j = new JsonObject();
                double ratio = (double)toolHead.getUnitValue() / 1.8144E7;
                j.addProperty("heat_capacity", (Number)(heatCapacityForHeating * ratio));
                j.addProperty("forging_temperature", (Number)((double)meltTemp * 0.6));
                j.addProperty("welding_temperature", (Number)((double)meltTemp * 0.8));
                JsonObject ingrediient = new JsonObject();
                ingrediient.addProperty("tag", toolHead.getMaterialTag(material).f_203868_().toString());
                j.add("ingredient", (JsonElement)ingrediient);
                GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + toolHead.getId() + ".json"), j.toString().getBytes());
                ingrediient = new JsonObject();
                ingrediient.addProperty("item", toolType.getDomain() + ":" + material.getId() + "_" + toolType.getId());
                j.add("ingredient", (JsonElement)ingrediient);
                GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation("gt5r", "tfc/item_heats/metal/" + material.getId() + "_" + toolType.getId() + ".json"), j.toString().getBytes());
            }
        }
    }
}

