/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.tuple.Triple;
import org.gtreimagined.gt5r.integration.xei.OreByProduct;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.integration.jei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.util.Utils;

public class OreProcessingCategory
implements IRecipeCategory<OreByProduct> {
    IDrawable icon = RecipeMapCategory.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_41834_.m_7968_());
    IDrawable background = OreProcessingCategory.createDrawable("background");
    IDrawable base = OreProcessingCategory.createDrawable("base");
    IDrawable chemical = OreProcessingCategory.createDrawable("chem");
    IDrawable sep = OreProcessingCategory.createDrawable("sep");
    IDrawable sift = OreProcessingCategory.createDrawable("sift");
    IDrawable smelt = OreProcessingCategory.createDrawable("smelt");
    public static final RecipeType<OreByProduct> ORE_BYPRODUCTS = new RecipeType(new ResourceLocation("gt5r", "ore_byproducts_tree"), OreByProduct.class);

    private static IDrawable createDrawable(String id) {
        return RecipeMapCategory.guiHelper.drawableBuilder(new ResourceLocation("gt5r", "textures/gui/ore_byproducts/" + id + ".png"), 3, 3, 180, 160).setTextureSize(186, 166).build();
    }

    public void draw(OreByProduct recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.base.draw(stack);
        if (recipe.bathingMode() != OreByProduct.BathingMode.NONE) {
            this.chemical.draw(stack);
        }
        if (recipe.hasSiftingRecipe()) {
            this.sift.draw(stack);
        }
        if (recipe.hasSepRecipes()) {
            this.sep.draw(stack);
        }
        if (recipe.hasFurnaceSmeltingRecipe()) {
            this.smelt.draw(stack);
        }
        List<Triple<Integer, Integer, Integer>> chances = recipe.getChanceOverlays();
        for (Triple<Integer, Integer, Integer> chancePositions : chances) {
            int chance = (Integer)chancePositions.getRight();
            if (chance <= 0 || chance >= 10000) continue;
            RenderSystem.m_69461_();
            RenderSystem.m_69465_();
            stack.m_85836_();
            stack.m_85841_(0.5f, 0.5f, 1.0f);
            String ch = chance / 100 + "%";
            Minecraft.m_91087_().f_91062_.m_92750_(stack, ch, 2.0f * (float)((Integer)chancePositions.getLeft()).intValue(), 2.0f * (float)((Integer)chancePositions.getMiddle()).intValue(), 0xFFFF00);
            stack.m_85849_();
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OreByProduct recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(GTMaterialTypes.ORE.getMaterialIngredient(recipe.material(), 1).m_43908_()));
        recipe.getSlots().forEach(r -> {
            IRecipeSlotBuilder slotBuilder = builder.addSlot(r.input() ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, r.x(), r.y());
            if (!r.stacks().isEmpty()) {
                slotBuilder.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, r.stacks());
            }
            if (!r.fluidStacks().isEmpty()) {
                slotBuilder.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, r.fluidStacks());
            }
            if (r.chance() > 0) {
                slotBuilder.addTooltipCallback((recipe1, tooltip) -> tooltip.add(Utils.literal((String)("Output Chance: " + (float)r.chance() / 100.0f + "%")).m_130940_(ChatFormatting.WHITE)));
            }
        });
    }

    public Component getTitle() {
        return Utils.translatable((String)"jei.category.gt5r.ore_byproducts_tree", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<OreByProduct> getRecipeType() {
        return ORE_BYPRODUCTS;
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("gt5r", "ore_byproducts_tree");
    }

    public Class<? extends OreByProduct> getRecipeClass() {
        return OreByProduct.class;
    }
}

