/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityCoalBoiler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.mixin.client.AbstractContainerScreenAccessor;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoalBoilerWidget
extends Widget {
    private int heat = 0;
    private int maxHeat = 0;
    private int water = 0;
    private int steam = 0;

    protected CoalBoilerWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
    }

    public static WidgetSupplier build() {
        return CoalBoilerWidget.builder(CoalBoilerWidget::new);
    }

    public void init() {
        super.init();
        this.gui.syncInt(() -> ((BlockEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getHeat(), i -> {
            this.heat = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((BlockEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getMaxHeat(), i -> {
            this.maxHeat = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((ContainerMachine)this.gui.container).getTile().fluidHandler.map(t -> t.getInputs()[0].getAmount()).orElse(0), i -> {
            this.water = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((ContainerMachine)this.gui.container).getTile().fluidHandler.map(t -> t.getOutputs()[0].getAmount()).orElse(0), i -> {
            this.steam = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public void render(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        int y;
        int lvl;
        float per;
        if (this.water >= 1) {
            per = (float)this.water / 16000.0f;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = this.realY() + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX() + 13, y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 28, 54 - lvl, 10, lvl);
        }
        if (this.steam >= 1) {
            per = (float)this.steam / 16000.0f;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = this.realY() + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX(), y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 18, 54 - lvl, 10, lvl);
        }
        if (this.heat >= 1) {
            per = (float)this.heat / (float)this.maxHeat;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = ((AbstractContainerScreenAccessor)this.gui.screen).getTopPos() + 25 + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX() + 26, y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 38, 54 - lvl, 10, lvl);
        }
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        if (this.water >= 1) {
            this.renderTooltip(stack, "Water: " + this.water + " MB", mouseX, mouseY, 14, 0, 10, 54);
        }
        if (this.steam >= 1) {
            this.renderTooltip(stack, "Steam: " + this.steam + " MB", mouseX, mouseY, 0, 0, 10, 54);
        }
        this.renderTooltip(stack, "Heat: " + this.heat + "C\u00b0 out of " + this.maxHeat, mouseX, mouseY, 26, 0, 10, 54);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(PoseStack matrixStack, String text, double mouseX, double mouseY, int x, int y, int w, int h) {
        if (this.isInside(x, y, w, h, mouseX, mouseY)) {
            this.renderTooltip(matrixStack, (Component)Utils.literal((String)text), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }
}

