/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.events.forge;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.gtreimagined.gt5r.blockentity.multi.MiningPipeStructureCache;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.worldgen.PlayerPlacedBlockSavedData;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.events.GTCommonEvents;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.BlockOre;

public class RemappingEvents {
    UUID bearUUID = UUID.fromString("1964e3d1-6500-40e7-9ff2-e6161d41a8c2");

    @SubscribeEvent
    public static void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player targetPlayer;
        Entity entity;
        ItemStack handStack = event.getPlayer().m_21120_(event.getHand());
        if (handStack.m_204117_(GTTools.WRENCH.getTag()) && (entity = event.getTarget()) instanceof Player && (targetPlayer = (Player)entity).m_142081_().equals(GTCommonEvents.BEAR_UUID)) {
            Random random = event.getPlayer().m_21187_();
            targetPlayer.m_7678_(targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), (float)random.nextInt(180), targetPlayer.m_146909_());
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            PlayerPlacedBlockSavedData.getOrCreate(serverLevel).removeBlockPos(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (event.getEntity() instanceof Player) {
                PlayerPlacedBlockSavedData.getOrCreate(serverLevel).addBlockPos(event.getBlockSnapshot().getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (event.getEntity() instanceof Player) {
                PlayerPlacedBlockSavedData savedData = PlayerPlacedBlockSavedData.getOrCreate(serverLevel);
                for (BlockSnapshot snapshot : event.getReplacedBlockSnapshots()) {
                    savedData.addBlockPos(snapshot.getPos());
                }
            }
        }
    }

    @SubscribeEvent
    public static void remapMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings("antimatter_shared").forEach(map -> {
            Block block;
            String id = map.key.m_135815_();
            if (id.contains("oilsands") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("oilsands", "oil_shale").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("quartzite") && !id.contains("__") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("quartzite", "milky_quartz").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("blue_sapphire") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("blue_sapphire", "sapphire").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("cooperite") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("cooperite", "sheldonite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("phosphorus") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("phosphorus", "tricalcium_phosphate").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("polyethylene") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("polyethylene", "plastic"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("nitric_oxide") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("nitric_oxide", "nitrogen_monoxide"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("banded_iron") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("banded_iron", "hematite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("chrome") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("chrome", "chromium").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("palladium") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("palladium", "sperrylite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("aluminium") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("aluminium", "alumina").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("uranium") && !id.contains("uranium_2") && (block = (Block)GTAPI.get(Block.class, (String)id.replace("uranium", "uraninite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if ((id.contains("granite_red") || id.contains("granite_black")) && (block = (Block)GTAPI.get(Block.class, (String)id.replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
            }
        });
        for (RegistryEvent.MissingMappings.Mapping map2 : Stream.of(event.getMappings("gregtech"), event.getMappings("gti")).flatMap(Collection::stream).toList()) {
            Block block;
            Block replacement;
            Material mat;
            String id = map2.key.m_135815_();
            if (id.startsWith("block_") && (mat = Material.get((String)id.replace("block_", ""))) != Material.NULL) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(mat).asBlock());
                continue;
            }
            if (id.equals("ore_stone_salt")) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Salt).asBlock());
                continue;
            }
            if (id.equals("ore_stone_rock_salt")) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ORE_STONE.get()).get(Materials.Sylvite).asBlock());
                continue;
            }
            if (id.startsWith("ore_") && (replacement = (Block)GTAPI.get(BlockOre.class, (String)id)) != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Block)GTAPI.get(Block.class, (String)id, (String)"antimatter_shared");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Block)GTAPI.get(Block.class, (String)id, (String)"gt5r");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            if (id.equals("rubber_log")) {
                map2.remap((IForgeRegistryEntry)GTCoreBlocks.RUBBER_LOG);
            }
            if (id.equals("rubber_leaves")) {
                map2.remap((IForgeRegistryEntry)GTCoreBlocks.RUBBER_LEAVES);
            }
            if (id.equals("rubber_sapling")) {
                map2.remap((IForgeRegistryEntry)GTCoreBlocks.RUBBER_SAPLING);
            }
            if (!((Map)GTRemapping.getRemappingMap().get("gt5r")).containsKey(id) || (block = (Block)GTAPI.get(Block.class, (ResourceLocation)((ResourceLocation)((Map)GTRemapping.getRemappingMap().get("gt5r")).get(id)))) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings("antimatter_shared").forEach(map -> {
            Item block;
            String id = map.key.m_135815_();
            if (id.contains("oilsands") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("oilsands", "oil_shale").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("blue_sapphire") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("blue_sapphire", "sapphire").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("cooperite") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("cooperite", "sheldonite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("phosphorus") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("phosphorus", "tricalcium_phosphate").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("polyethylene") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("polyethylene", "plastic"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("nitric_oxide") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("nitric_oxide", "nitrogen_monoxide"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("banded_iron") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("banded_iron", "hematite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("chrome") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("chrome", "chromium").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("palladium") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("palladium", "sperrylite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("aluminium") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("aluminium", "alumina").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("uranium") && !id.contains("uranium_2") && (block = (Item)GTAPI.get(Item.class, (String)id.replace("uranium", "uraninite").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if ((id.contains("granite_red") || id.contains("granite_black")) && (block = (Block)GTAPI.get(Block.class, (String)id.replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block.m_5456_());
            }
        });
        for (RegistryEvent.MissingMappings.Mapping map2 : Stream.of(event.getMappings("gregtech"), event.getMappings("gti")).flatMap(Collection::stream).toList()) {
            Item block;
            String id = map2.key.m_135815_();
            Item replacement = (Item)GTAPI.get(Item.class, (String)id, (String)"antimatter_shared");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Item)GTAPI.get(Item.class, (String)id, (String)"gt5r");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            if (!((Map)GTRemapping.getRemappingMap().get("gt5r")).containsKey(id) || (block = (Item)GTAPI.get(Item.class, (ResourceLocation)((ResourceLocation)((Map)GTRemapping.getRemappingMap().get("gt5r")).get(id)))) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void remapMissingFluids(RegistryEvent.MissingMappings<Fluid> event) {
        GTFluid fluid;
        String liquid;
        String id;
        for (RegistryEvent.MissingMappings.Mapping map : event.getMappings("gt5r")) {
            id = map.key.m_135815_();
            String string = liquid = id.startsWith("flowing_") ? id.replace("flowing_", "") : id;
            if (id.contains("polethylene")) {
                liquid = liquid.replace("polethylene", "plastic");
            }
            if ((fluid = (GTFluid)GTAPI.get(GTFluid.class, (String)liquid)) == null) continue;
            map.remap((IForgeRegistryEntry)(id.startsWith("flowing_") ? fluid.getFlowingFluid() : fluid.getFluid()));
        }
        for (RegistryEvent.MissingMappings.Mapping map : event.getMappings("antimatter_shared")) {
            id = map.key.m_135815_();
            String string = liquid = id.startsWith("flowing_") ? id.replace("flowing_", "") : id;
            if (id.contains("polethylene")) {
                liquid = liquid.replace("polethylene", "plastic");
            }
            if (id.contains("nitric_oxide")) {
                liquid = liquid.replace("nitric_oxide", "nitrogen_monoxide");
            }
            if (id.contains("sodium_persulfate")) {
                liquid = liquid.replace("sodium_persulfate", "sodium_persulfate_solution");
            }
            if ((fluid = (GTFluid)GTAPI.get(GTFluid.class, (String)liquid)) == null) continue;
            map.remap((IForgeRegistryEntry)(id.startsWith("flowing_") ? fluid.getFlowingFluid() : fluid.getFluid()));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        MiningPipeStructureCache.onWorldUnload(event.getWorld());
    }
}

