/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.datagen;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.block.BlockAsphalt;
import org.gtreimagined.gt5r.block.BlockAsphaltSlab;
import org.gtreimagined.gt5r.block.BlockAsphaltStair;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.block.BlockFakeCasing;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.AppliedEnergisticsRegistrar;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTBlockTagProvider;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class GT5RBlockTagProvider
extends GTBlockTagProvider {
    public GT5RBlockTagProvider(String providerDomain, String providerName, boolean replace) {
        super(providerDomain, providerName, replace);
    }

    public void processTags(String domain) {
        super.processTags(domain);
        GTAPI.all(BlockCasing.class, (String)"gt5r", cas -> {
            if (cas.getId().contains("long_distance_wire")) {
                this.tag(GTTools.WIRE_CUTTER.getToolType()).add((Object)cas);
                return;
            }
            this.tag(GTTools.WRENCH.getToolType()).add((Object)cas);
        });
        GTAPI.all(BlockColoredWall.class, (String)"gt5r", cas -> {
            if (cas.getMaterial() == Materials.Wood) {
                this.tag(GTTools.AXE.getToolType()).add((Object)cas);
            } else {
                this.tag(GTTools.WRENCH.getToolType()).add((Object)cas);
            }
        });
        GTAPI.all(BlockFakeCasing.class, (String)"gt5r", cas -> this.tag(GTTools.PICKAXE.getToolType()).add((Object)cas));
        for (DyeColor color : DyeColor.values()) {
            this.tag(GT5RTags.ASPHALT).add((Object)RegistryUtils.getBlockFromId((ResourceLocation)new ResourceLocation(color.m_41065_() + "_concrete")));
        }
        GTAPI.all(BlockAsphalt.class, (String)"gt5r", cas -> {
            this.tag(GT5RTags.ASPHALT).add((Object)cas);
            this.tag(GTTools.PICKAXE.getToolType()).add((Object)cas);
        });
        GTAPI.all(BlockAsphaltSlab.class, (String)"gt5r", cas -> {
            this.tag(GT5RTags.ASPHALT).add((Object)cas);
            this.tag(GTTools.PICKAXE.getToolType()).add((Object)cas);
        });
        GTAPI.all(BlockAsphaltStair.class, (String)"gt5r", cas -> {
            this.tag(GT5RTags.ASPHALT).add((Object)cas);
            this.tag(GTTools.PICKAXE.getToolType()).add((Object)cas);
        });
        GTAPI.all(BlockCoil.class, (String)"gt5r", cas -> this.tag(GTTools.WRENCH.getToolType()).add((Object)cas));
        this.tag(GTTools.AXE.getToolType()).add((Object[])new Block[]{GT5RBlocks.BRITTLE_CHARCOAL, GT5RBlocks.POWDER_BARREL});
        this.tag(GTTools.PICKAXE.getToolType()).add((Object[])new Block[]{GT5RBlocks.MINING_PIPE, GT5RBlocks.MINING_PIPE_THIN, GT5RBlocks.SOLID_SUPER_FUEL});
        this.tag(BlockTags.f_144284_).add((Object)GT5RMachines.MINIATURE_NETHER_PORTAL.getBlockState(Tier.NONE));
        if (GTAPI.isModLoaded((String)"ae2")) {
            this.tag(GTTools.WRENCH.getToolType()).add((Object)AppliedEnergisticsRegistrar.getAe2Block("cable_bus"));
            this.tag(GTTools.PICKAXE.getToolType()).remove((Object[])new Block[]{AppliedEnergisticsRegistrar.getAe2Block("cable_bus")});
        }
    }
}

