/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverBasicRedstoneInput
extends BaseCover {
    protected int redstonePower;
    boolean inverted = false;

    public CoverBasicRedstoneInput(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public boolean isPowered() {
        return this.inverted ? this.redstonePower == 0 : this.redstonePower > 0;
    }

    public int getRedstonePower() {
        return this.redstonePower;
    }

    public void onBlockUpdate() {
        this.redstonePower = this.handler.getTile().m_58904_().m_46681_(this.handler.getTile().m_58899_().m_142300_(this.side), this.side);
    }

    public void onFirstTick() {
        this.onBlockUpdate();
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverBasicRedstoneInput.getBasicModel();
    }

    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        if (type != null && type.getTag() == GTTools.SCREWDRIVER.getTag()) {
            this.inverted = !this.inverted;
            player.m_6352_((Component)Utils.translatable((String)("message.gt5r.redstone_mode." + (this.inverted ? "inverted" : "normal")), (Object[])new Object[0]), player.m_142081_());
            for (Direction dir : Direction.values()) {
                if (dir == this.side) continue;
                this.source().get(dir).onBlockUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        return super.onInteract(player, hand, side, type);
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128379_("inverted", this.inverted);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.inverted = nbt.m_128471_("inverted");
    }

    public List<String> getInfo(boolean simple) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Inverted: " + this.inverted);
        return info;
    }
}

