/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstone;
import org.gtreimagined.gt5r.cover.base.CoverBasicTransport;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.SyncableTextWidget;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverRobotArm
extends CoverBasicTransport {
    int slot = 0;
    int slotLimit = 0;
    String test = "";

    public CoverRobotArm(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    @Override
    protected void addButtons() {
        this.addGuiCallback(t -> {
            t.addCycleButton(70, 16, 16, 16, h -> ((CoverBasicRedstone)h).redstoneMode.ordinal(), true, i -> "tooltip.gt5r.redstone_mode." + i, new ButtonOverlay[]{ButtonOverlay.TORCH_OFF, ButtonOverlay.TORCH_ON, ButtonOverlay.REDSTONE});
            t.addCycleButton(88, 16, 16, 16, h -> ((CoverRobotArm)h).exportMode.ordinal(), true, i -> "tooltip.gt5r.export_mode." + i, new ButtonOverlay[]{ButtonOverlay.EXPORT, ButtonOverlay.IMPORT, ButtonOverlay.EXPORT_IMPORT, ButtonOverlay.IMPORT_EXPORT});
            t.addTextButton(70, 53, 36, 12, h -> ((CoverRobotArm)h).slot, i -> Utils.literal((String)"Slot: ").m_130946_("" + i), (Object)0, true);
            t.addButton(61, 34, ButtonOverlay.MINUS, true);
            t.addButton(97, 34, ButtonOverlay.PLUS, true);
            t.addWidget(SyncableTextWidget.build(i -> {
                CoverRobotArm robotArm = (CoverRobotArm)i;
                if (robotArm.slotLimit == 0) {
                    return "N/A";
                }
                return String.valueOf(robotArm.slotLimit);
            }, (int)0x404040, (boolean)true).setSize(78, 38, 18, 18));
        });
    }

    protected String getRenderId() {
        return "conveyor";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverRobotArm.getBasicDepthModel();
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        if (object instanceof ItemStack) {
            BlockEntity blockEntity;
            ItemStack stack = (ItemStack)object;
            if (!this.exportMode.isExport() && (blockEntity = this.handler.getTile()) instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
                if (inputSide && machine.itemHandler.isPresent()) {
                    if (stack.m_41619_()) {
                        return true;
                    }
                    if (this.slotLimit > 0 && stack.m_41613_() < this.slotLimit) {
                        return true;
                    }
                    ItemStack toInsert = this.slotLimit > 0 ? Utils.ca((int)this.slotLimit, (ItemStack)stack) : stack.m_41777_();
                    MachineItemHandler itemHandler = (MachineItemHandler)machine.itemHandler.get();
                    if (itemHandler.getInputCount() > 0) {
                        ItemStack inserted = itemHandler.getInputHandler().insertItem(this.slot, toInsert, true);
                        if (inserted.m_41619_()) {
                            if (!simulate) {
                                itemHandler.getInputHandler().insertItem(this.slot, toInsert, false);
                            }
                            stack.m_41764_(0);
                        } else if (inserted.m_41613_() < toInsert.m_41613_()) {
                            if (!simulate) {
                                itemHandler.getInputHandler().insertItem(this.slot, toInsert, false);
                            }
                            stack.m_41764_(toInsert.m_41613_() - inserted.m_41613_());
                        }
                    } else if (itemHandler.getHandler(SlotType.STORAGE).getSlots() > 0) {
                        ItemStack inserted = itemHandler.getHandler(SlotType.STORAGE).insertItem(this.slot, toInsert, true);
                        if (inserted.m_41619_()) {
                            if (!simulate) {
                                itemHandler.getHandler(SlotType.STORAGE).insertItem(this.slot, toInsert, false);
                            }
                            stack.m_41764_(0);
                        } else if (inserted.m_41613_() < toInsert.m_41613_()) {
                            if (!simulate) {
                                itemHandler.getHandler(SlotType.STORAGE).insertItem(this.slot, toInsert, false);
                            }
                            stack.m_41764_(toInsert.m_41613_() - inserted.m_41613_());
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        ImportExportMode previous = this.exportMode;
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            BlockEntity blockEntity;
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            int button = ev.data[1];
            if (button == 1 && previous.isExport() != this.exportMode.isExport()) {
                this.slot = 0;
                this.handler.getTile().m_6596_();
            }
            if (button == 2 && (blockEntity = this.handler.getTile()) instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
                machine.itemHandler.ifPresent(h -> {
                    if (this.exportMode.isExport()) {
                        if (h.getOutputCount() > 0) {
                            ++this.slot;
                            if (this.slot >= h.getOutputCount()) {
                                this.slot = 0;
                            }
                        } else {
                            this.slot = 0;
                        }
                    }
                    if (!this.exportMode.isExport()) {
                        if (h.getInputCount() > 0) {
                            ++this.slot;
                            if (this.slot >= h.getInputCount()) {
                                this.slot = 0;
                            }
                        } else if (h.getHandler(SlotType.STORAGE).getSlots() > 0) {
                            ++this.slot;
                            if (this.slot >= h.getHandler(SlotType.STORAGE).getSlots()) {
                                this.slot = 0;
                            }
                        } else {
                            this.slot = 0;
                        }
                    }
                    machine.m_6596_();
                });
            }
            if (button == 3 && this.slotLimit > 0) {
                --this.slotLimit;
                this.handler.getTile().m_6596_();
            }
            if (button == 4 && this.slotLimit < 64) {
                ++this.slotLimit;
                this.handler.getTile().m_6596_();
            }
        }
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.slot = nbt.m_128451_("slot");
        if (nbt.m_128441_("slotLimit")) {
            this.slotLimit = nbt.m_128451_("slotLimit");
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("slot", this.slot);
        nbt.m_128405_("slotLimit", this.slotLimit);
        return nbt;
    }
}

