/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.cover.CoverFluidFilter;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.RedstoneMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicTransport;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverPump
extends CoverBasicTransport
implements IFilterableHandler {
    public static String ID = "pump";
    private final CoverFluidFilter filter;
    public static final Map<Tier, Integer> speeds = ImmutableMap.builder().put((Object)Tier.LV, (Object)32).put((Object)Tier.MV, (Object)128).put((Object)Tier.HV, (Object)512).put((Object)Tier.EV, (Object)2048).put((Object)Tier.IV, (Object)8192).build();

    public CoverPump(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        Objects.requireNonNull(tier);
        this.filter = new CoverFluidFilter(source, null, side, GT5RCovers.COVER_FLUID_FILTER);
        this.filter.onCreate();
        this.gui.getSlots().add(SlotType.STORAGE, 79, 53);
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverPump.getBasicDepthModel();
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        if (object instanceof FluidStack) {
            FluidStack stack = (FluidStack)object;
            if (this.getInventory(SlotType.STORAGE).getStackInSlot(0).m_41619_()) {
                return false;
            }
            return this.filter.onTransfer(stack, inputSide, simulate);
        }
        return super.onTransfer(object, inputSide, simulate);
    }

    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return cap != IFluidHandler.class;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        if (this.handler.getTile() == null) {
            return;
        }
        BlockPos from = this.handler.getTile().m_58899_();
        BlockPos to = this.handler.getTile().m_58899_().m_142300_(this.side);
        Direction fromSide = this.side;
        if (this.exportMode == ImportExportMode.IMPORT || this.exportMode == ImportExportMode.IMPORT_EXPORT) {
            from = this.handler.getTile().m_58899_().m_142300_(this.side);
            to = this.handler.getTile().m_58899_();
            fromSide = this.side.m_122424_();
        }
        BlockPos finalTo = to;
        if (this.canMove(this.side)) {
            Direction finalFromSide = fromSide;
            FluidUtils.getFluidHandler((Level)this.handler.getTile().m_58904_(), (BlockPos)from, (Direction)fromSide).ifPresent(ih -> FluidUtils.getFluidHandler((Level)this.handler.getTile().m_58904_(), (BlockPos)finalTo, (Direction)finalFromSide.m_122424_()).ifPresent(other -> Utils.transferFluids((IFluidHandler)ih, (IFluidHandler)other, (int)speeds.get(this.tier))));
        }
    }

    protected boolean canMove(Direction side) {
        if (this.redstoneMode != RedstoneMode.NO_WORK) {
            boolean powered = this.isPowered(side);
            return this.redstoneMode == RedstoneMode.INVERTED != powered;
        }
        return true;
    }

    public boolean test(SlotType<?> type, int slot, ItemStack stack) {
        return stack.m_41720_() == GT5RCovers.COVER_FLUID_FILTER.getItem().m_41720_();
    }

    public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
        if (tile == this && event == SlotType.STORAGE) {
            ItemStack slotStack = this.getInventory(SlotType.STORAGE).getStackInSlot(data[0]);
            if (slotStack.m_41619_()) {
                this.filter.clearFilter();
            } else {
                this.filter.addInfoFromStack(slotStack);
            }
        }
        super.onMachineEvent(tile, event, data);
    }

    public void addInfoFromStack(ItemStack stack) {
        super.addInfoFromStack(stack);
        this.onMachineEvent((IGuiHandler)this, (IMachineEvent)SlotType.STORAGE, 0);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("filter")) {
            this.filter.deserialize(nbt.m_128469_("filter"));
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128365_("filter", (Tag)this.filter.serialize());
        return nbt;
    }
}

