/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import org.gtreimagined.gt5r.cover.base.CoverFilter;
import org.gtreimagined.gt5r.gui.ButtonOverlays;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityItemPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItemFilter
extends CoverFilter {
    public CoverItemFilter(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.getGui().getSlots().add(SlotType.DISPLAY_SETTABLE, 88, 53);
        this.addGuiCallback(t -> {
            t.addSwitchButton(70, 34, 16, 16, ButtonOverlay.WHITELIST, ButtonOverlay.BLACKLIST, h -> this.blacklist, true, b -> "tooltip.gt5r." + (b != false ? "blacklist" : "whitelist"));
            t.addSwitchButton(88, 34, 16, 16, ButtonOverlays.NBT_OFF, ButtonOverlays.NBT_ON, h -> !this.ignoreNBT, true, b -> "tooltip.gt5r.nbt." + (b != false ? "on" : "off"));
            t.addCycleButton(106, 34, 16, 15, h -> ((CoverItemFilter)h).filterMode, true, i -> "tooltip.gt5r.filter_mode." + i, new ButtonOverlay[]{ButtonOverlay.EXPORT_IMPORT, ButtonOverlay.IMPORT, ButtonOverlay.EXPORT});
        });
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
        this.getInventory(SlotType.DISPLAY_SETTABLE).clearContent();
    }

    public boolean canPlace() {
        BlockEntityItemPipe itemPipe;
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityItemPipe && (itemPipe = (BlockEntityItemPipe)blockEntity).getCachedBlockEntity(this.side) instanceof BlockEntityItemPipe) {
            return false;
        }
        return super.canPlace();
    }

    public boolean blockConnection(Direction side) {
        BlockEntityItemPipe itemPipe;
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityItemPipe && (itemPipe = (BlockEntityItemPipe)blockEntity).getCachedBlockEntity(side) instanceof BlockEntityItemPipe) {
            return true;
        }
        return super.blockConnection(side);
    }

    public <T> boolean blocksCapability(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        super.onTransfer(object, inputSide, simulate);
        if (object instanceof ItemStack) {
            boolean matches;
            ItemStack item = (ItemStack)object;
            if (this.filterMode == 1 && !inputSide || this.filterMode == 2 && inputSide) {
                return false;
            }
            ItemStack filter = this.getInventory(SlotType.DISPLAY_SETTABLE).getStackInSlot(0);
            boolean empty = filter.m_41619_();
            if (empty && !this.blacklist) {
                return true;
            }
            boolean bl = matches = this.ignoreNBT ? item.m_150930_(filter.m_41720_()) : ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)filter);
            if (this.blacklist == matches) {
                return true;
            }
        }
        return false;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 0) {
                this.blacklist = !this.blacklist;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            } else if (ev.data[1] == 1) {
                this.ignoreNBT = !this.ignoreNBT;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            } else if (ev.data[1] == 2) {
                this.filterMode = this.filterMode == 0 ? (byte)1 : (this.filterMode == 1 ? (byte)2 : (byte)0);
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            }
        }
    }

    protected String getRenderId() {
        return "item_filter";
    }

    public String getId() {
        return "item_filter";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverItemFilter.getBasicModel();
    }
}

