/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.gtreimagined.gt5r.cover.base.CoverFilter;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverFluidFilter
extends CoverFilter {
    public CoverFluidFilter(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.getGui().getSlots().add(SlotType.FLUID_DISPLAY_SETTABLE, 79, 53);
        this.addGuiCallback(t -> {
            t.addSwitchButton(70, 34, 16, 16, ButtonOverlay.WHITELIST, ButtonOverlay.BLACKLIST, h -> this.blacklist, true, b -> "tooltip.gt5r." + (b != false ? "blacklist" : "whitelist"));
            t.addCycleButton(88, 34, 16, 15, h -> ((CoverFluidFilter)h).filterMode, true, i -> "tooltip.gt5r.filter_mode." + i, new ButtonOverlay[]{ButtonOverlay.EXPORT_IMPORT, ButtonOverlay.IMPORT, ButtonOverlay.EXPORT});
        });
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
        this.getInventory(SlotType.FLUID_DISPLAY_SETTABLE).clearContent();
    }

    public <T> boolean blocksCapability(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 0) {
                this.blacklist = !this.blacklist;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            } else if (ev.data[1] == 1) {
                this.filterMode = this.filterMode == 0 ? (byte)1 : (this.filterMode == 1 ? (byte)2 : (byte)0);
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityBase) {
                    BlockEntityBase base = (BlockEntityBase)blockEntity;
                    base.sidedSync(true);
                }
            }
        }
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        super.onTransfer(object, inputSide, simulate);
        if (object instanceof FluidStack) {
            boolean empty;
            FluidStack fluidHolder = (FluidStack)object;
            if (this.filterMode == 1 && !inputSide || this.filterMode == 2 && inputSide) {
                return false;
            }
            ItemStack filter = this.getInventory(SlotType.FLUID_DISPLAY_SETTABLE).getStackInSlot(0);
            boolean bl = empty = filter.m_41619_() || filter.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(f -> {
                for (int i = 0; i < f.getTanks(); ++i) {
                    if (f.getFluidInTank(i).isEmpty()) continue;
                    return false;
                }
                return true;
            }).orElse(true) != false;
            if (empty && !this.blacklist) {
                return true;
            }
            boolean matches = filter.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(f -> {
                for (int i = 0; i < f.getTanks(); ++i) {
                    boolean match;
                    boolean bl = this.ignoreNBT ? fluidHolder.getFluid() == f.getFluidInTank(i).getFluid() : (match = f.getFluidInTank(i).isFluidEqual(fluidHolder));
                    if (!match) continue;
                    return true;
                }
                return false;
            }).orElse(false);
            return this.blacklist == matches;
        }
        return false;
    }

    protected String getRenderId() {
        return "fluid_filter";
    }

    public String getId() {
        return "fluid_filter";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverFluidFilter.getBasicModel();
    }
}

