/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstoneOutput;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverFluidDetector
extends CoverBasicRedstoneOutput {
    public CoverFluidDetector(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlace() {
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            if (machine.fluidHandler.side(this.side).isPresent()) return true;
        }
        if (!(this.handler.getTile() instanceof BlockEntityFluidPipe)) return false;
        return true;
    }

    public String getId() {
        return "fluid_detector";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverFluidDetector.getBasicModel();
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_() == null || this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        IFluidHandler fluidContainer = this.handler.getTile().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.side).map(f -> f).orElse(null);
        if (fluidContainer != null) {
            int scale = IntStream.range(0, fluidContainer.getTanks()).map(arg_0 -> ((IFluidHandler)fluidContainer).getTankCapacity(arg_0)).sum() / 15;
            int totalFluid = IntStream.range(0, fluidContainer.getTanks()).map(tankSlot -> {
                FluidStack fluidHolder = fluidContainer.getFluidInTank(tankSlot);
                return fluidHolder.getAmount();
            }).sum();
            if (scale > 0) {
                this.setOutputRedstone(this.inverted ? 15 - totalFluid / scale : totalFluid / scale);
            } else {
                this.setOutputRedstone(this.inverted ? 15 : 0);
            }
        }
    }
}

