/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.cover.CoverFluidFilter;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverAdvancedFluidDetector
extends BaseCover
implements IFilterableHandler {
    boolean inverted = false;
    int outputRedstone = 0;
    private final CoverFluidFilter filter;

    public CoverAdvancedFluidDetector(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.filter = new CoverFluidFilter(source, null, side, GT5RCovers.COVER_FLUID_FILTER);
        this.filter.onCreate();
        this.addGuiCallback(t -> t.addSwitchButton(70, 34, 16, 16, ButtonOverlay.TORCH_OFF, ButtonOverlay.TORCH_ON, h -> this.inverted, true, b -> "tooltip.gt5r.redstone_mode." + (b != false ? "inverted" : "normal")));
        this.gui.getSlots().add(SlotType.STORAGE, 88, 34);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlace() {
        BlockEntity blockEntity = this.handler.getTile();
        if (!(blockEntity instanceof BlockEntityMachine)) return false;
        BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
        if (!machine.fluidHandler.side(this.side).isPresent()) return false;
        return true;
    }

    public String getId() {
        return "fluid_detector";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverAdvancedFluidDetector.getBasicModel();
    }

    public boolean hasGui() {
        return true;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_() == null || this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            if (machine.fluidHandler.side(this.side).isPresent()) {
                IFluidHandler fluidContainer = (IFluidHandler)machine.fluidHandler.side(this.side).resolve().get();
                int oldRedstone = this.outputRedstone;
                int scale = IntStream.range(0, fluidContainer.getTanks()).map(tankSlot -> {
                    FluidStack fluidHolder = fluidContainer.getFluidInTank(tankSlot);
                    if (!this.getInventory(SlotType.STORAGE).getStackInSlot(0).m_41619_() && this.filter.onTransfer(fluidHolder, true, true)) {
                        return 0;
                    }
                    return fluidContainer.getTankCapacity(tankSlot);
                }).sum() / 15;
                int totalFluid = IntStream.range(0, fluidContainer.getTanks()).map(tankSlot -> {
                    FluidStack fluidHolder = fluidContainer.getFluidInTank(tankSlot);
                    if (!this.getInventory(SlotType.STORAGE).getStackInSlot(0).m_41619_() && this.filter.onTransfer(fluidHolder, true, true)) {
                        return 0;
                    }
                    return fluidHolder.getAmount();
                }).sum();
                if (scale > 0) {
                    this.outputRedstone = this.inverted ? 15 - totalFluid / scale : totalFluid / scale;
                } else {
                    int n = this.outputRedstone = this.inverted ? 15 : 0;
                }
                if (this.outputRedstone != oldRedstone) {
                    this.markAndNotifySource();
                }
            }
        }
    }

    public int getWeakPower() {
        return this.outputRedstone;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128365_("filter", (Tag)this.filter.serialize());
        nbt.m_128379_("inverted", this.inverted);
        return nbt;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 0) {
                this.inverted = !this.inverted;
                this.handler.getTile().m_6596_();
            }
        }
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("filter")) {
            this.filter.deserialize(nbt.m_128469_("filter"));
        }
        this.inverted = nbt.m_128471_("inverted");
    }

    public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
        if (tile == this && event == SlotType.STORAGE) {
            ItemStack slotStack = this.getInventory(SlotType.STORAGE).getStackInSlot(data[0]);
            if (slotStack.m_41619_()) {
                this.filter.clearFilter();
            } else {
                this.filter.addInfoFromStack(slotStack);
            }
        }
        super.onMachineEvent(tile, event, data);
    }

    public void addInfoFromStack(ItemStack stack) {
        super.addInfoFromStack(stack);
        this.onMachineEvent((IGuiHandler)this, (IMachineEvent)SlotType.STORAGE, 0);
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        return stack.m_41720_() == GT5RCovers.COVER_FLUID_FILTER.getItem().m_41720_();
    }
}

