/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.blockentity.single.ISteamBoilerHandler;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntitySolarBoiler
extends BlockEntityMachine<BlockEntitySolarBoiler> {
    public BlockEntitySolarBoiler(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new LavaBoilerFluidHandler(this));
        this.recipeHandler.set(() -> new SolarBoilerRecipeHandler(this));
    }

    public int getHeat() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).getHeat()).orElse(0);
    }

    public int getMaxHeat() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).getMaxHeat()).orElse(0);
    }

    public boolean isAllowedToWork() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).isAllowedToWork()).orElse(false);
    }

    public static class SolarBoilerRecipeHandler
    extends MachineRecipeHandler<BlockEntitySolarBoiler>
    implements ISteamBoilerHandler {
        int maxHeat = 1000;
        int heat;
        int lossTimer = 0;
        boolean hadNoWater;

        public SolarBoilerRecipeHandler(BlockEntitySolarBoiler tile) {
            super((BlockEntityMachine)tile);
        }

        @Override
        public int getProcessDelay() {
            return 25;
        }

        @Override
        public int getLossTimerMax() {
            return 45;
        }

        @Override
        public int getHeat() {
            return this.heat;
        }

        @Override
        public void setHeat(int heat) {
            this.heat = heat;
        }

        @Override
        public int getLossTimer() {
            return this.lossTimer;
        }

        @Override
        public void setLossTimer(int lossTimer) {
            this.lossTimer = lossTimer;
        }

        @Override
        public boolean hadNoWater() {
            return this.hadNoWater;
        }

        @Override
        public void setHadNoWater(boolean hadNoWater) {
            this.hadNoWater = hadNoWater;
        }

        @Override
        public BlockEntityMachine<?> getTile() {
            return this.tile;
        }

        @Override
        public void exportFluid() {
            if (((BlockEntitySolarBoiler)this.tile).fluidHandler.map(f -> f.getOutputTanks().isEmpty()).orElse(false).booleanValue()) {
                return;
            }
            this.exportFluidFromMachineToSide(((BlockEntitySolarBoiler)this.tile).getFacing());
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        private boolean isAllowedToWork() {
            return ((BlockEntitySolarBoiler)this.tile).m_58904_().m_45527_(((BlockEntitySolarBoiler)this.tile).m_58899_().m_7494_()) && ((BlockEntitySolarBoiler)this.tile).m_58904_().m_46461_() && !((BlockEntitySolarBoiler)this.tile).m_58904_().m_46758_(((BlockEntitySolarBoiler)this.tile).m_58899_().m_7494_()) && !((BlockEntitySolarBoiler)this.tile).m_58904_().m_46470_();
        }

        public void onServerUpdate() {
            this.tick();
            if (((BlockEntitySolarBoiler)this.tile).m_58904_().m_46467_() % 12L == 0L) {
                if (this.isAllowedToWork()) {
                    ++this.heat;
                    if (this.heat >= this.maxHeat) {
                        this.heat = this.maxHeat;
                    }
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
            super.onServerUpdate();
        }

        public void exportFluidFromMachineToSide(Direction side) {
            LazyOptional cap = FluidUtils.getFluidHandler((Level)((BlockEntitySolarBoiler)this.tile).m_58904_(), (BlockPos)((BlockEntitySolarBoiler)this.tile).m_58899_().m_142300_(side), (BlockEntity)((BlockEntitySolarBoiler)this.tile).getCachedBlockEntity(side), (Direction)side.m_122424_());
            ((BlockEntitySolarBoiler)this.tile).fluidHandler.ifPresent(f -> cap.ifPresent(other -> Utils.transferFluids((IFluidHandler)f.getOutputTanks(), (IFluidHandler)other, (int)1000)));
        }

        public void setActive(boolean t) {
            if (t && ((BlockEntitySolarBoiler)this.tile).getMachineState() != MachineState.ACTIVE) {
                ((BlockEntitySolarBoiler)this.tile).setMachineState(MachineState.ACTIVE);
            } else if (!t && ((BlockEntitySolarBoiler)this.tile).getMachineState() == MachineState.ACTIVE) {
                ((BlockEntitySolarBoiler)this.tile).setMachineState(MachineState.IDLE);
            }
        }

        public boolean accepts(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_ || fluid.getFluid() == Materials.DistilledWater.getLiquid();
        }

        public boolean canOutput() {
            return true;
        }

        public CompoundTag serialize() {
            CompoundTag nbt = super.serialize();
            nbt.m_128405_("heat", this.heat);
            nbt.m_128405_("maxHeat", this.maxHeat);
            nbt.m_128405_("lossTimer", this.lossTimer);
            nbt.m_128379_("hadNoWater", this.hadNoWater);
            return nbt;
        }

        public void deserialize(CompoundTag nbt) {
            super.deserialize(nbt);
            this.heat = nbt.m_128451_("heat");
            this.maxHeat = nbt.m_128451_("maxHeat");
            this.lossTimer = nbt.m_128451_("lossTimer");
            this.hadNoWater = nbt.m_128471_("hadNoWater");
        }
    }

    public static class LavaBoilerFluidHandler
    extends MachineFluidHandler<BlockEntitySolarBoiler> {
        public LavaBoilerFluidHandler(BlockEntitySolarBoiler tile) {
            super((BlockEntityMachine)tile);
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_IN, b -> {
                b.tank(p -> p.getFluid() == Fluids.f_76193_ || p.getFluid() == Materials.DistilledWater.getLiquid(), 16000);
                return b;
            }));
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_OUT, b -> {
                b.tank(16000);
                return b;
            }));
        }

        protected FluidTanks getCellAccessibleTanks() {
            return this.getInputTanks();
        }
    }
}

