/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityUniversalExtender;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.ToolTypes;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gtcore.blockentity.IInventorySyncTile;
import org.gtreimagined.gtcore.network.MessageTriggerInventorySync;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.IPostTickTile;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.DefaultHeatHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.pipe.TileTicker;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityNuclearReactorCore
extends BlockEntityMachine<BlockEntityNuclearReactorCore>
implements IFilterableHandler,
IPostTickTile,
IInventorySyncTile {
    public int[] mNeutronCounts = new int[]{0, 0, 0, 0};
    public int[] oNeutronCounts = new int[]{0, 0, 0, 0};
    public long oldHeat = 0L;
    public byte mode = 0;
    public boolean oRunning;
    public boolean mRunning = false;
    public static final int[] S2103 = new int[]{0, 0, 2, 1, 0, 3, 0};
    public static final int[] S0312 = new int[]{0, 0, 0, 3, 1, 2, 0};
    BlockEntityNuclearReactorCore[] adjacentReactors = new BlockEntityNuclearReactorCore[4];
    boolean syncSlots;

    public BlockEntityNuclearReactorCore(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new MachineFluidHandler((BlockEntityMachine)this, 64000, 1, 1));
        this.itemHandler.set(() -> new MachineItemHandler<BlockEntityNuclearReactorCore>(this){

            protected TrackedItemHandler<BlockEntityNuclearReactorCore> createTrackedHandler(SlotType<?> type, BlockEntityNuclearReactorCore tile) {
                if (type == SlotType.STORAGE) {
                    return new TrackedItemHandler<BlockEntityNuclearReactorCore>(tile, type, 4, type.output, type.input, type.tester, 1){

                        @NotNull
                        public ItemStack extractItem(int slot, int amount, boolean simulate) {
                            IItemReactorRod reactorRod;
                            Item item = this.getStackInSlot(slot).m_41720_();
                            if (item instanceof IItemReactorRod && (reactorRod = (IItemReactorRod)item).isReactorRod(this.getStackInSlot(slot))) {
                                return ItemStack.f_41583_;
                            }
                            return super.extractItem(slot, amount, simulate);
                        }
                    };
                }
                return super.createTrackedHandler(type, (BlockEntityMachine)tile);
            }
        });
        this.heatHandler.set(() -> new DefaultHeatHandler((BlockEntityBase)this, Integer.MAX_VALUE, 0, 0));
    }

    public ItemStack getRod(int slot) {
        return this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public void setRod(int slot, ItemStack stack) {
        this.itemHandler.ifPresent(i -> i.getHandler(SlotType.STORAGE).setStackInSlot(slot, stack));
    }

    public void onFirstTickClient(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickClient(level, pos, state);
        GTLibNetwork.NETWORK.sendToServer((Packet)new MessageTriggerInventorySync(this.m_58899_()));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getMachineState() == MachineState.ACTIVE) {
            this.setMachineState(MachineState.IDLE);
        }
        if (this.syncSlots) {
            this.syncSlots();
            this.syncSlots = false;
        }
    }

    public boolean wrenchMachine(Player player, BlockHitResult res, boolean crouch) {
        return this.setOutputFacing(player, Utils.getInteractSide((BlockHitResult)res)) || this.setFacing(Utils.getInteractSide((BlockHitResult)res));
    }

    public void syncSlots() {
        if (this.m_58904_() != null && this.isServerSide()) {
            this.sidedSync(true);
        }
    }

    public void onRemove() {
        super.onRemove();
        TileTicker.SERVER_TICK_POST.remove((Object)this);
        TileTicker.SERVER_TICK_PO2T.remove((Object)this);
    }

    public void onLoad() {
        super.onLoad();
        TileTicker.SERVER_TICK_POST.add(this);
        TileTicker.SERVER_TICK_PO2T.add(this);
    }

    private BlockEntityNuclearReactorCore getCachedReactor(Direction side) {
        BlockEntityNuclearReactorCore core;
        BlockEntity cached = this.getCachedBlockEntity(side);
        return cached instanceof BlockEntityNuclearReactorCore ? (core = (BlockEntityNuclearReactorCore)cached) : null;
    }

    protected BlockEntity findBlockEntity(Direction side) {
        BlockEntity entity = this.f_58857_.m_7702_(this.m_58899_().m_142300_(side));
        if (entity instanceof BlockEntityUniversalExtender) {
            BlockEntityUniversalExtender universalExtender;
            entity = universalExtender.getCachedBlockEntity((universalExtender = (BlockEntityUniversalExtender)entity).getFacing() == side.m_122424_() ? universalExtender.getOutputFacing() : universalExtender.getFacing());
        }
        return entity;
    }

    public boolean isReactorRodModerated(int aSlot) {
        Item item = this.getRod(aSlot).m_41720_();
        if (item instanceof IItemReactorRod) {
            IItemReactorRod reactorRod = (IItemReactorRod)item;
            boolean isModerated = reactorRod.isModerated(this, aSlot, this.getRod(aSlot));
            if (this.getMachineState() == MachineState.DISABLED || (this.mode & Ref.B[aSlot]) != 0) {
                return false;
            }
            return isModerated;
        }
        return false;
    }

    public void updateReactorRodModeration(int aSlot) {
        Item item = this.getRod(aSlot).m_41720_();
        if (item instanceof IItemReactorRod) {
            IItemReactorRod reactorRod = (IItemReactorRod)item;
            reactorRod.updateModeration(this, aSlot, this.getRod(aSlot));
        }
    }

    public int getReactorRodNeutronEmission(int aSlot) {
        Item item;
        if (this.getMachineState() != MachineState.DISABLED && (this.mode & Ref.B[aSlot]) == 0 && (item = this.getRod(aSlot).m_41720_()) instanceof IItemReactorRod) {
            IItemReactorRod reactorRod = (IItemReactorRod)item;
            return reactorRod.getReactorRodNeutronEmission(this, aSlot, this.getRod(aSlot));
        }
        this.mNeutronCounts[aSlot] = 0;
        return 0;
    }

    public boolean getReactorRodNeutronReaction(int aSlot) {
        Item item;
        if (this.m_58904_().m_46467_() % 20L == 18L) {
            int n = aSlot;
            this.mNeutronCounts[n] = this.mNeutronCounts[n] - this.oNeutronCounts[aSlot];
        }
        if (this.getMachineState() != MachineState.DISABLED && (this.mode & Ref.B[aSlot]) == 0 && (item = this.getRod(aSlot).m_41720_()) instanceof IItemReactorRod) {
            IItemReactorRod reactorRod = (IItemReactorRod)item;
            return reactorRod.getReactorRodNeutronReaction(this, aSlot, this.getRod(aSlot));
        }
        return false;
    }

    public int getReactorRodNeutronReflection(int aSlot, int aNeutrons, boolean aModerated) {
        Item item;
        if (this.getMachineState() != MachineState.DISABLED && (this.mode & Ref.B[aSlot]) == 0 && (item = this.getRod(aSlot).m_41720_()) instanceof IItemReactorRod) {
            IItemReactorRod reactorRod = (IItemReactorRod)item;
            return reactorRod.getReactorRodNeutronReflection(this, aSlot, this.getRod(aSlot), aNeutrons, aModerated);
        }
        return 0;
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        IItemReactorRod reactorRod;
        Item item;
        ItemStack held = player.m_21120_(hand);
        if (hit.m_82434_() == Direction.UP && this.getCover(Direction.UP).isEmpty() && ((item = held.m_41720_()) instanceof IItemReactorRod && (reactorRod = (IItemReactorRod)item).isReactorRod(held) || type == ToolTypes.PINCERS)) {
            Vec3 vec = hit.m_82450_();
            double x = vec.f_82479_ - (double)pos.m_123341_();
            double z = vec.f_82481_ - (double)pos.m_123343_();
            int tSlot = x < 0.5 ? (z < 0.5 ? 0 : 1) : (z < 0.5 ? 2 : 3);
            ItemStack stack = this.getRod(tSlot);
            if (stack.m_41619_() && type != ToolTypes.PINCERS) {
                this.setRod(tSlot, Utils.ca((int)1, (ItemStack)held));
                held.m_41774_(1);
                if (this.getMachineState() != MachineState.DISABLED) {
                    this.disableMachine();
                }
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_12490_, SoundSource.BLOCKS, 10.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!stack.m_41619_() && type == ToolTypes.PINCERS) {
                if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, true);
                }
                this.setRod(tSlot, ItemStack.f_41583_);
                Utils.damageStack((ItemStack)held, (LivingEntity)player);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_12490_, SoundSource.BLOCKS, 10.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (held.m_41720_() == GT5RItems.GeigerCounter) {
            player.m_6352_((Component)Utils.translatable((String)"message.gt5r.nuclear_reactor.neutron_levels", (Object[])new Object[]{this.oNeutronCounts[0], this.oNeutronCounts[1], this.oNeutronCounts[2], this.oNeutronCounts[3]}), player.m_142081_());
            player.m_6352_((Component)Utils.translatable((String)("message.gt5r.nuclear_reactor." + (this.getMachineState() == MachineState.DISABLED ? "off" : "on")), (Object[])new Object[0]), player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        IItemReactorRod reactorRod;
        Item item = stack.m_41720_();
        return item instanceof IItemReactorRod && (reactorRod = (IItemReactorRod)item).isReactorRod(stack);
    }

    public void onUnregisterPost() {
    }

    public Function<Direction, Texture> getMultiTexture() {
        return direction -> this.type.getBaseTexture(this.tier, Direction.UP, this.machineState);
    }

    public void onServerTickPost(Level level, BlockPos pos, boolean aFirst) {
        block49: {
            long tCalc;
            block48: {
                BlockEntityNuclearReactorCore tAdjacent;
                if (!aFirst) break block48;
                if (level.m_46467_() % 20L != 19L || this.machineState == MachineState.DISABLED) break block49;
                BlockEntityNuclearReactorCore[] adjacentReactors = new BlockEntityNuclearReactorCore[4];
                Direction.Plane.HORIZONTAL.forEach(d -> {
                    BlockEntityNuclearReactorCore core = this.getCachedReactor((Direction)d);
                    if (core != null) {
                        adjacentReactors[d.m_122416_()] = core;
                    }
                });
                int tNeutronCount = this.getReactorRodNeutronEmission(0);
                boolean tModerated = this.isReactorRodModerated(0);
                if (tNeutronCount != 0 || tModerated) {
                    this.mNeutronCounts[0] = this.mNeutronCounts[0] + this.getReactorRodNeutronReflection(1, tNeutronCount, tModerated);
                    this.mNeutronCounts[0] = this.mNeutronCounts[0] + this.getReactorRodNeutronReflection(2, tNeutronCount, tModerated);
                    tAdjacent = adjacentReactors[Direction.NORTH.m_122416_()];
                    if (tAdjacent != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + tAdjacent.getReactorRodNeutronReflection(S2103[Direction.SOUTH.m_122411_()], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = adjacentReactors[Direction.WEST.m_122416_()]) != null) {
                        this.mNeutronCounts[0] = this.mNeutronCounts[0] + tAdjacent.getReactorRodNeutronReflection(S0312[Direction.EAST.m_122411_()], tNeutronCount, tModerated);
                    }
                }
                tNeutronCount = this.getReactorRodNeutronEmission(1);
                tModerated = this.isReactorRodModerated(1);
                if (tNeutronCount != 0 || tModerated) {
                    this.mNeutronCounts[1] = this.mNeutronCounts[1] + this.getReactorRodNeutronReflection(0, tNeutronCount, tModerated);
                    this.mNeutronCounts[1] = this.mNeutronCounts[1] + this.getReactorRodNeutronReflection(3, tNeutronCount, tModerated);
                    tAdjacent = adjacentReactors[Direction.SOUTH.m_122416_()];
                    if (tAdjacent != null) {
                        this.mNeutronCounts[1] = this.mNeutronCounts[1] + tAdjacent.getReactorRodNeutronReflection(S0312[Direction.NORTH.m_122411_()], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = adjacentReactors[Direction.WEST.m_122416_()]) != null) {
                        this.mNeutronCounts[1] = this.mNeutronCounts[1] + tAdjacent.getReactorRodNeutronReflection(S2103[Direction.EAST.m_122411_()], tNeutronCount, tModerated);
                    }
                }
                tNeutronCount = this.getReactorRodNeutronEmission(2);
                tModerated = this.isReactorRodModerated(2);
                if (tNeutronCount != 0 || tModerated) {
                    this.mNeutronCounts[2] = this.mNeutronCounts[2] + this.getReactorRodNeutronReflection(0, tNeutronCount, tModerated);
                    this.mNeutronCounts[2] = this.mNeutronCounts[2] + this.getReactorRodNeutronReflection(3, tNeutronCount, tModerated);
                    tAdjacent = adjacentReactors[Direction.NORTH.m_122416_()];
                    if (tAdjacent != null) {
                        this.mNeutronCounts[2] = this.mNeutronCounts[2] + tAdjacent.getReactorRodNeutronReflection(S0312[Direction.SOUTH.m_122411_()], tNeutronCount, tModerated);
                    }
                    if ((tAdjacent = adjacentReactors[Direction.EAST.m_122416_()]) != null) {
                        this.mNeutronCounts[2] = this.mNeutronCounts[2] + tAdjacent.getReactorRodNeutronReflection(S2103[Direction.WEST.m_122411_()], tNeutronCount, tModerated);
                    }
                }
                tNeutronCount = this.getReactorRodNeutronEmission(3);
                tModerated = this.isReactorRodModerated(3);
                if (tNeutronCount == 0 && !tModerated) break block49;
                this.mNeutronCounts[3] = this.mNeutronCounts[3] + this.getReactorRodNeutronReflection(1, tNeutronCount, tModerated);
                this.mNeutronCounts[3] = this.mNeutronCounts[3] + this.getReactorRodNeutronReflection(2, tNeutronCount, tModerated);
                tAdjacent = adjacentReactors[Direction.SOUTH.m_122416_()];
                if (tAdjacent != null) {
                    this.mNeutronCounts[3] = this.mNeutronCounts[3] + tAdjacent.getReactorRodNeutronReflection(S2103[Direction.NORTH.m_122411_()], tNeutronCount, tModerated);
                }
                if ((tAdjacent = adjacentReactors[Direction.EAST.m_122416_()]) == null) break block49;
                this.mNeutronCounts[3] = this.mNeutronCounts[3] + tAdjacent.getReactorRodNeutronReflection(S0312[Direction.WEST.m_122411_()], tNeutronCount, tModerated);
                break block49;
            }
            if (level.m_46467_() % 20L == 19L) {
                this.updateReactorRodModeration(0);
                this.updateReactorRodModeration(1);
                this.updateReactorRodModeration(2);
                this.updateReactorRodModeration(3);
            }
            if ((tCalc = CodeUtils.divup((long)((this.oNeutronCounts[0] = this.mNeutronCounts[0]) + (this.oNeutronCounts[1] = this.mNeutronCounts[1]) + (this.oNeutronCounts[2] = this.mNeutronCounts[2]) + (this.oNeutronCounts[3] = this.mNeutronCounts[3])), (long)256L)) > 0L && level.m_46467_() % 20L == 10L) {
                for (LivingEntity tEntity : level.m_45976_(LivingEntity.class, new AABB(pos.m_142082_(-200, 0, -200).m_175288_(level.m_141937_()), pos.m_142082_(200, 0, 200).m_175288_(level.m_151558_())))) {
                    int tStrength = CodeUtils.bindInt((long)((long)((double)tCalc - tEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))));
                    if (tStrength <= 0) continue;
                    Utils.applyRadioactivity((Entity)tEntity, (int)((int)CodeUtils.divup((long)tStrength, (long)10L)), (int)tStrength);
                }
            }
            this.oRunning = this.mRunning;
            this.mRunning = tCalc != 0L;
            DefaultHeatHandler handler = (DefaultHeatHandler)this.heatHandler.orElse(null);
            MachineFluidHandler fluidHandler1 = (MachineFluidHandler)this.fluidHandler.orElse(null);
            int tEnergy = handler.getHeat();
            if (this.getReactorRodNeutronReaction(0)) {
                this.mRunning = true;
            }
            if (this.getReactorRodNeutronReaction(1)) {
                this.mRunning = true;
            }
            if (this.getReactorRodNeutronReaction(2)) {
                this.mRunning = true;
            }
            if (this.getReactorRodNeutronReaction(3)) {
                this.mRunning = true;
            }
            if (this.oRunning != this.mRunning) {
                this.sidedSync(true);
            }
            FluidStack coldCoolant = fluidHandler1.getInputTanks().getFluidInTank(0);
            int tDivider = 1;
            if (coldCoolant.getFluid().m_205067_(Materials.Sodium.getFluidTag())) {
                tDivider = 6;
            }
            if (coldCoolant.getFluid().m_205067_(Materials.Tin.getFluidTag())) {
                tDivider = 3;
            }
            handler.setCurrentHeat((int)(CodeUtils.divup((long)(handler.getHeat() - tEnergy), (long)tDivider) + (long)tEnergy));
            this.oldHeat = handler.getHeat() - tEnergy;
            if (handler.getHeat() > 0) {
                boolean isExploding = false;
                Material hotCoolant = null;
                int heatPerCoolant = 0;
                if (coldCoolant.getFluid().m_205067_(Materials.Coolant.getFluidTag())) {
                    heatPerCoolant = 20;
                    hotCoolant = Materials.HotCoolant;
                } else if (coldCoolant.getFluid().m_205067_(Materials.DistilledWater.getFluidTag())) {
                    heatPerCoolant = 80;
                    hotCoolant = Materials.Steam;
                } else if (coldCoolant.getFluid().m_205067_(Materials.Tin.getFluidTag())) {
                    heatPerCoolant = 40;
                    hotCoolant = Materials.HotMoltenTin;
                } else if (coldCoolant.getFluid().m_205067_(Materials.Sodium.getFluidTag())) {
                    heatPerCoolant = 30;
                    hotCoolant = Materials.HotMoltenSodium;
                } else if (coldCoolant.getFluid().m_205067_(Materials.SemiheavyWater.getFluidTag())) {
                    heatPerCoolant = 40;
                    hotCoolant = Materials.HotSemiheavyWater;
                } else if (coldCoolant.getFluid().m_205067_(Materials.HeavyWater.getFluidTag())) {
                    heatPerCoolant = 50;
                    hotCoolant = Materials.HotHeavyWater;
                } else if (coldCoolant.getFluid().m_205067_(Materials.TritiatedWater.getFluidTag())) {
                    heatPerCoolant = 60;
                    hotCoolant = Materials.HotTritiatedWater;
                } else if (coldCoolant.getFluid().m_205067_(Materials.LithiumChloride.getFluidTag())) {
                    heatPerCoolant = 15;
                    hotCoolant = Materials.HotMoltenLithiumChloride;
                } else if (coldCoolant.getFluid().m_205067_(Materials.CarbonDioxide.getFluidTag())) {
                    heatPerCoolant = 20;
                    hotCoolant = Materials.HotCarbonDioxide;
                } else if (coldCoolant.getFluid().m_205067_(Materials.Helium.getFluidTag())) {
                    heatPerCoolant = 30;
                    hotCoolant = Materials.HotHelium;
                } else if (coldCoolant.getFluid().m_205067_(Materials.ThoriumSalt.getFluidTag())) {
                    heatPerCoolant = 2560000;
                    hotCoolant = Materials.HotCoolant;
                }
                if (heatPerCoolant == 0 || hotCoolant == null) {
                    isExploding = true;
                } else {
                    int toFill;
                    tEnergy = handler.getHeat() / heatPerCoolant;
                    int multiplier = hotCoolant == Materials.Steam ? 160 : 1;
                    int n = toFill = hotCoolant == Materials.Steam ? tEnergy * 160 : tEnergy;
                    if (tEnergy > 0) {
                        FluidStack fluidHolder;
                        FluidStack fluidStack = fluidHolder = hotCoolant.has(new IMaterialTag[]{GTMaterialTypes.GAS}) ? hotCoolant.getGas(tEnergy * multiplier) : hotCoolant.getLiquid(tEnergy);
                        if (coldCoolant.getAmount() >= tEnergy && (long)fluidHandler1.fillOutput(fluidHolder.copy(), IFluidHandler.FluidAction.SIMULATE) == (long)tEnergy * (long)multiplier) {
                            fluidHandler1.fillOutput(fluidHolder, IFluidHandler.FluidAction.EXECUTE);
                            handler.extractInternal(tEnergy * heatPerCoolant, false);
                            fluidHandler1.drainInput(tEnergy, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
                if (isExploding && !((MachineItemHandler)this.itemHandler.get()).getHandler(SlotType.STORAGE).isEmpty()) {
                    level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    tCalc *= 2L;
                    this.setRod(0, ItemStack.f_41583_);
                    this.setRod(1, ItemStack.f_41583_);
                    this.setRod(2, ItemStack.f_41583_);
                    this.setRod(3, ItemStack.f_41583_);
                    for (LivingEntity tEntity : level.m_45976_(LivingEntity.class, new AABB(pos.m_142082_(-500, 0, -500).m_175288_(level.m_141937_()), pos.m_142082_(500, 0, 500).m_175288_(level.m_151558_())))) {
                        int tStrength = CodeUtils.bindInt((long)((long)((double)tCalc - tEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))));
                        if (tStrength <= 0) continue;
                        Utils.applyRadioactivity((Entity)tEntity, (int)((int)CodeUtils.divup((long)tStrength, (long)10L)), (int)tStrength);
                    }
                }
            }
        }
    }

    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == SlotType.STORAGE) {
            this.sidedSync(true);
        }
        super.onMachineEvent(event, data);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("mode", this.mode);
        tag.m_128356_("oldHeat", this.oldHeat);
        ListTag currentNeutronCountTag = new ListTag();
        ListTag oldNeutronCountTag = new ListTag();
        for (int i = 0; i < 4; ++i) {
            currentNeutronCountTag.add((Object)IntTag.m_128679_((int)this.mNeutronCounts[i]));
            oldNeutronCountTag.add((Object)IntTag.m_128679_((int)this.oNeutronCounts[i]));
        }
        tag.m_128365_("currentNeutronCounts", (Tag)currentNeutronCountTag);
        tag.m_128365_("oldNeutronCounts", (Tag)oldNeutronCountTag);
        tag.m_128379_("oRunning", this.oRunning);
        tag.m_128379_("mRunning", this.mRunning);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.itemHandler.ifPresent(e -> {
            CompoundTag in = new CompoundTag();
            e.getAll().forEach((f, i) -> in.m_128365_(f.getId(), (Tag)this.serializeWithEmpty((IItemHandler)i, new CompoundTag())));
            nbt.m_128365_("it", (Tag)in);
        });
        nbt.m_128379_("oRunning", this.oRunning);
        nbt.m_128379_("mRunning", this.mRunning);
        return nbt;
    }

    public CompoundTag serializeWithEmpty(IItemHandler container, CompoundTag nbt) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < container.getSlots(); ++i) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            container.getStackInSlot(i).m_41739_(itemTag);
            itemTag.m_128405_("count", container.getStackInSlot(i).m_41613_());
            nbtTagList.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mode = tag.m_128445_("mode");
        this.oldHeat = tag.m_128454_("oldHeat");
        this.mRunning = tag.m_128471_("mRunning");
        this.oRunning = tag.m_128471_("oRunning");
        ListTag currentNeutronCountTag = tag.m_128437_("currentNeutronCounts", 3);
        ListTag oldNeutronCountTag = tag.m_128437_("oldNeutronCounts", 3);
        for (int i = 0; i < 4; ++i) {
            this.mNeutronCounts[i] = currentNeutronCountTag.m_128763_(i);
            this.oNeutronCounts[i] = oldNeutronCountTag.m_128763_(i);
        }
    }

    public boolean canPlayerOpenGui(Player playerEntity) {
        return playerEntity.m_7500_();
    }

    @Generated
    public void setSyncSlots(boolean syncSlots) {
        this.syncSlots = syncSlots;
    }
}

