/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtlib.blockentity.single.BlockEntityGenerator;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class BlockEntityMagicEnergyConverter
extends BlockEntityGenerator<BlockEntityMagicEnergyConverter> {
    long leftoverToInsert;

    public BlockEntityMagicEnergyConverter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityMagicEnergyConverter>(this){

            public IRecipe findRecipe() {
                IRecipe recipe = super.findRecipe();
                if (recipe == null) {
                    recipe = BlockEntityMagicEnergyConverter.this.itemHandler.map(i -> i).map(i -> {
                        ItemStack input = i.getInputHandler().getStackInSlot(0);
                        long eu = BlockEntityMagicEnergyConverter.this.euFromItem(input);
                        if (eu > 0L) {
                            ItemStack output = input.m_41720_() == Items.f_42690_ ? new ItemStack((ItemLike)Items.f_42517_) : input.m_41777_();
                            EnchantmentHelper.m_44865_(Map.of(), (ItemStack)output);
                            return RecipeMaps.MAGIC_FUELS.RB().recipeMapOnly().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)input.m_41777_())}).io(new ItemStack[]{output}).add("enchanted_item", 1L, eu);
                        }
                        return null;
                    }).orElse(null);
                }
                return recipe;
            }

            public boolean accepts(ItemStack stack) {
                return super.accepts(stack) || !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty();
            }
        });
        this.itemHandler.set(() -> new MachineItemHandler<BlockEntityMagicEnergyConverter>(this){

            public ITrackedHandler getCellInputHandler() {
                return super.getInputHandler();
            }

            public ITrackedHandler getCellOutputHandler() {
                return super.getOutputHandler();
            }

            public ITrackedHandler getHandler(SlotType<?> type) {
                if (type == SlotType.CELL_IN) {
                    type = SlotType.IT_IN;
                }
                if (type == SlotType.CELL_OUT) {
                    type = SlotType.IT_OUT;
                }
                return super.getHandler(type);
            }
        });
    }

    private long euFromItem(ItemStack tStack) {
        if (tStack.m_41619_()) {
            return 0L;
        }
        long tEU = 0L;
        Map tMap = EnchantmentHelper.m_44831_((ItemStack)tStack);
        for (Map.Entry e : tMap.entrySet()) {
            Enchantment ench = (Enchantment)e.getKey();
            Integer tLevel = (Integer)e.getValue();
            tEU += 1000000L * (long)tLevel.intValue() / (long)ench.m_6586_() / (long)ench.m_44699_().m_44716_();
        }
        return tEU;
    }
}

