/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityLimitedOutput<T extends BlockEntityLimitedOutput<T>>
extends BlockEntityMachine<T> {
    protected int stackLimit = 0;
    boolean observeStackLimit = false;

    public BlockEntityLimitedOutput(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new LimitedOutputItemHandler<BlockEntityLimitedOutput>(this));
    }

    public boolean transferItems(IItemHandler from, IItemHandler to, boolean once) {
        boolean successful = false;
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack inserted;
            ItemStack toInsert = from.extractItem(i, from.getStackInSlot(i).m_41613_(), true);
            if (toInsert.m_41619_() || !(inserted = Utils.insertItem((IItemHandler)to, (ItemStack)toInsert, (boolean)true)).m_41619_()) continue;
            Utils.insertItem((IItemHandler)to, (ItemStack)toInsert, (boolean)false);
            from.extractItem(i, toInsert.m_41613_(), false);
            if (!successful) {
                successful = true;
            }
            if (once) break;
        }
        return successful;
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(GTTools.SCREWDRIVER.getTag()) && (Utils.getInteractSide((BlockHitResult)hit) == this.getFacing().m_122424_() || hit.m_82434_() == this.getFacing().m_122424_())) {
            if (!this.observeStackLimit) {
                if (this.stackLimit > 0 && this.stackLimit < 65) {
                    this.observeStackLimit = true;
                } else {
                    int n = this.stackLimit = player.m_6047_() ? 65 : 0;
                }
            }
            this.stackLimit = player.m_6047_() ? --this.stackLimit : ++this.stackLimit;
            if (this.stackLimit == 65 || this.stackLimit == 0) {
                this.observeStackLimit = false;
                player.m_6352_((Component)Utils.literal((String)"Do not regulate Item Stack size"), player.m_142081_());
            } else {
                player.m_6352_((Component)Utils.literal((String)("Item Output Limit: " + this.stackLimit)), player.m_142081_());
            }
            stack.m_41629_(1, world.f_46441_, (ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("stackLimit", this.stackLimit);
        tag.m_128379_("observeStackLimit", this.observeStackLimit);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stackLimit = tag.m_128451_("stackLimit");
        this.observeStackLimit = tag.m_128471_("observeStackLimit");
        if (this.stackLimit > 0 && !this.observeStackLimit) {
            this.observeStackLimit = true;
        }
    }

    public static class LimitedOutputItemHandler<T extends BlockEntityLimitedOutput<T>>
    extends MachineItemHandler<T> {
        public LimitedOutputItemHandler(T tile) {
            super(tile);
            int count = tile.getMachineType() == GT5RMachines.SUPER_BUFFER ? 256 : tile.getMachineType().getCount(tile.getMachineTier(), SlotType.STORAGE);
            this.inventories.put((Object)SlotType.STORAGE, (Object)new TrackedItemHandler<T>((BlockEntityLimitedOutput)tile, SlotType.STORAGE, count, true, true, (t, s) -> true, (BlockEntityLimitedOutput)tile){
                final /* synthetic */ BlockEntityLimitedOutput val$tile;
                {
                    this.val$tile = blockEntityLimitedOutput;
                    super((IGuiHandler)tile, type, size, output, input, validator);
                }

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (!this.val$tile.observeStackLimit) {
                        return super.extractItem(slot, amount, simulate);
                    }
                    if (amount < this.val$tile.stackLimit) {
                        return ItemStack.f_41583_;
                    }
                    amount = this.val$tile.stackLimit;
                    return super.extractItem(slot, amount, simulate);
                }
            });
        }

        public boolean allowsInput(Direction side) {
            return side != ((BlockEntityLimitedOutput)this.tile).getFacing().m_122424_();
        }
    }
}

