/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.blockentity.single.ISteamBoilerHandler;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityLavaBoiler
extends BlockEntityMachine<BlockEntityLavaBoiler> {
    public BlockEntityLavaBoiler(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new LavaBoilerFluidHandler(this));
        this.recipeHandler.set(() -> new LavaBoilerRecipeHandler(this));
    }

    public int getHeat() {
        return this.recipeHandler.map(r -> ((LavaBoilerRecipeHandler)r).getHeat()).orElse(0);
    }

    public int getMaxHeat() {
        return this.recipeHandler.map(r -> ((LavaBoilerRecipeHandler)r).getMaxHeat()).orElse(0);
    }

    public static class LavaBoilerRecipeHandler
    extends MachineRecipeHandler<BlockEntityLavaBoiler>
    implements ISteamBoilerHandler {
        int maxHeat = 1000;
        int heat;
        int fuel = 0;
        int maxFuel;
        int lossTimer = 0;
        int lavaPerOperation = 100;
        boolean hadNoWater;

        public LavaBoilerRecipeHandler(BlockEntityLavaBoiler tile) {
            super((BlockEntityMachine)tile);
        }

        @Override
        public int getProcessDelay() {
            return 10;
        }

        @Override
        public int getLossTimerMax() {
            return 20;
        }

        @Override
        public int getHeat() {
            return this.heat;
        }

        @Override
        public void setHeat(int heat) {
            this.heat = heat;
        }

        @Override
        public int getLossTimer() {
            return this.lossTimer;
        }

        @Override
        public void setLossTimer(int lossTimer) {
            this.lossTimer = lossTimer;
        }

        @Override
        public boolean hadNoWater() {
            return this.hadNoWater;
        }

        @Override
        public void setHadNoWater(boolean hadNoWater) {
            this.hadNoWater = hadNoWater;
        }

        @Override
        public BlockEntityMachine<?> getTile() {
            return this.tile;
        }

        @Override
        public void exportFluid() {
            if (((BlockEntityLavaBoiler)this.tile).fluidHandler.map(f -> f.getOutputTanks().isEmpty()).orElse(false).booleanValue()) {
                return;
            }
            Arrays.stream(Direction.values()).filter(f -> f != Direction.DOWN).collect(Collectors.toList()).forEach(this::exportFluidFromMachineToSide);
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        public void onServerUpdate() {
            this.tick();
            if (((BlockEntityLavaBoiler)this.tile).m_58904_().m_46467_() % 10L == 0L) {
                ((BlockEntityLavaBoiler)this.tile).fluidHandler.ifPresent(f -> {
                    FluidStack[] inputs = f.getInputs();
                    if (inputs[1].getAmount() >= this.lavaPerOperation) {
                        this.setActive(true);
                        ++this.heat;
                        if (((BlockEntityLavaBoiler)this.tile).m_58904_().m_46467_() % 16L == 0L) {
                            f.drainInput(new FluidStack(inputs[1].getFluid(), this.lavaPerOperation), IFluidHandler.FluidAction.EXECUTE);
                        }
                        if (this.heat >= this.maxHeat) {
                            this.heat = this.maxHeat;
                        }
                    } else {
                        this.setActive(false);
                    }
                });
            }
            super.onServerUpdate();
        }

        public void exportFluidFromMachineToSide(Direction side) {
            if (((BlockEntityLavaBoiler)this.tile).fluidHandler.map(f -> f.getOutputTanks().isEmpty()).orElse(false).booleanValue()) {
                return;
            }
            LazyOptional cap = FluidUtils.getFluidHandler((Level)((BlockEntityLavaBoiler)this.tile).m_58904_(), (BlockPos)((BlockEntityLavaBoiler)this.tile).m_58899_().m_142300_(side), (BlockEntity)((BlockEntityLavaBoiler)this.tile).getCachedBlockEntity(side), (Direction)side.m_122424_());
            ((BlockEntityLavaBoiler)this.tile).fluidHandler.ifPresent(f -> cap.ifPresent(other -> Utils.transferFluids((IFluidHandler)f.getOutputTanks(), (IFluidHandler)other, (int)1000)));
        }

        public void setActive(boolean t) {
            if (t && ((BlockEntityLavaBoiler)this.tile).getMachineState() != MachineState.ACTIVE) {
                ((BlockEntityLavaBoiler)this.tile).setMachineState(MachineState.ACTIVE);
            } else if (!t && ((BlockEntityLavaBoiler)this.tile).getMachineState() == MachineState.ACTIVE) {
                ((BlockEntityLavaBoiler)this.tile).setMachineState(MachineState.IDLE);
            }
        }

        public boolean accepts(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_ || fluid.getFluid() == Materials.DistilledWater.getLiquid() || fluid.getFluid() == Fluids.f_76195_;
        }

        public boolean canOutput() {
            return true;
        }

        public CompoundTag serialize() {
            CompoundTag nbt = super.serialize();
            nbt.m_128405_("heat", this.heat);
            nbt.m_128405_("maxHeat", this.maxHeat);
            nbt.m_128405_("fuel", this.fuel);
            nbt.m_128405_("maxFuel", this.maxFuel);
            nbt.m_128405_("lossTimer", this.lossTimer);
            nbt.m_128379_("hadNoWater", this.hadNoWater);
            return nbt;
        }

        public void deserialize(CompoundTag nbt) {
            super.deserialize(nbt);
            this.heat = nbt.m_128451_("heat");
            this.maxHeat = nbt.m_128451_("maxHeat");
            this.fuel = nbt.m_128451_("fuel");
            this.maxFuel = nbt.m_128451_("maxFuel");
            this.lossTimer = nbt.m_128451_("lossTimer");
            this.hadNoWater = nbt.m_128471_("hadNoWater");
        }
    }

    public static class LavaBoilerFluidHandler
    extends MachineFluidHandler<BlockEntityLavaBoiler> {
        public LavaBoilerFluidHandler(BlockEntityLavaBoiler tile) {
            super((BlockEntityMachine)tile);
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_IN, b -> {
                b.tank(p -> p.getFluid() == Fluids.f_76193_ || p.getFluid() == Materials.DistilledWater.getLiquid(), 16000).tank(p -> p.getFluid() == Fluids.f_76195_, 16000);
                return b;
            }));
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((BlockEntityBase)tile, (IMachineEvent)SlotType.FL_OUT, b -> {
                b.tank(16000);
                return b;
            }));
        }

        protected FluidTanks getCellAccessibleTanks() {
            return this.getInputTanks();
        }
    }
}

