/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineCoverHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.types.HatchMachine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockEntityInputBus
extends BlockEntityHatch<BlockEntityInputBus> {
    boolean diversityFiltering = false;

    public BlockEntityInputBus(HatchMachine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new MachineItemHandler<BlockEntityInputBus>(this){

            protected TrackedItemHandler<BlockEntityInputBus> createTrackedHandler(SlotType<?> type, BlockEntityInputBus tile) {
                if (type == SlotType.IT_IN) {
                    int count = tile.getMachineType().getCount(tile.getMachineTier(), type);
                    return new TrackedItemHandler<BlockEntityInputBus>(tile, type, count, type.output, type.input, type.tester){

                        public boolean hasSlotDiversity() {
                            return BlockEntityInputBus.this.diversityFiltering;
                        }
                    };
                }
                return super.createTrackedHandler(type, (BlockEntityMachine)tile);
            }

            public boolean allowsInput(Direction side) {
                return side == BlockEntityInputBus.this.coverHandler.map(MachineCoverHandler::getOutputFacing).orElse(null);
            }
        });
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (type == GTTools.SCREWDRIVER) {
            ICover instance = this.coverHandler.map(h -> h.get(Utils.getInteractSide((BlockHitResult)hit))).orElse(ICover.empty);
            if (!player.m_6047_() && !instance.isEmpty() && instance.openGui(player, Utils.getInteractSide((BlockHitResult)hit))) {
                Utils.damageStack((ItemStack)stack, (InteractionHand)hand, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            this.diversityFiltering = !this.diversityFiltering;
            player.m_6352_((Component)Utils.translatable((String)("tooltip.gt5r.diversity_filter." + (this.diversityFiltering ? "on" : "off")), (Object[])new Object[0]), player.m_142081_());
            Utils.damageStack((ItemStack)stack, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }
}

