/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.blockentity.multi.IMiningPipeTile;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.gtlib.structure.StructureHandle;
import org.jetbrains.annotations.Nullable;

public class MiningPipeStructureCache {
    private static final Object2ObjectMap<Level, StructureCache.DimensionEntry> LOOKUP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<Level, Long2ObjectMap<Set<StructureHandle<?>>>> CALLBACKS = new Object2ObjectOpenHashMap();

    public static boolean validate(Level world, BlockPos pos, LongList structure, int maxAmount) {
        StructureCache.DimensionEntry e = (StructureCache.DimensionEntry)LOOKUP.computeIfAbsent((Object)world, w -> new StructureCache.DimensionEntry());
        if (!MiningPipeStructureCache.has(world, pos)) {
            boolean ok = e.validate(pos, maxAmount, structure);
            return ok;
        }
        return false;
    }

    public static int refCount(Level world, BlockPos pos) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return 0;
        }
        LongSet e = entry.get(pos);
        return e == null ? 0 : e.size();
    }

    public static boolean has(Level world, BlockPos pos) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return false;
        }
        long p = pos.m_121878_();
        LongList l = (LongList)entry.CONTROLLER_TO_STRUCTURE.get(p);
        if (l == null || l.size() == 0) {
            return false;
        }
        return ((LongSet)entry.STRUCTURE_TO_CONTROLLER.get(l.iterator().nextLong())).contains(p);
    }

    @Nullable
    public static LongSet get(Level world, BlockPos pos) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
        return entry != null ? entry.get(pos) : null;
    }

    @Nullable
    public static <T extends BlockEntityBasicMultiMachine> T getAnyMulti(Level world, BlockPos pos, Class<T> clazz) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return null;
        }
        LongSet list = entry.get(pos);
        if (list == null || list.size() == 0) {
            return null;
        }
        LongIterator longIterator = list.iterator();
        while (longIterator.hasNext()) {
            long e = (Long)longIterator.next();
            BlockPos p = BlockPos.m_122022_((long)e);
            BlockEntity tile = world.m_7702_(p);
            if (!clazz.isInstance(tile)) continue;
            return (T)((BlockEntityBasicMultiMachine)tile);
        }
        return null;
    }

    public static void add(Level world, BlockPos pos, LongList structure) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.computeIfAbsent((Object)world, e -> new StructureCache.DimensionEntry());
        entry.add(pos, structure);
        MiningPipeStructureCache.notifyListenersAdd(world, pos);
    }

    public static void remove(Level world, BlockPos pos) {
        StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return;
        }
        entry.remove(pos);
        MiningPipeStructureCache.notifyListenersRemove(world, pos);
    }

    private static void refreshController(Level world, BlockPos controller, BlockPos at) {
        BlockEntity tile = world.m_7702_(controller);
        if (tile instanceof IMiningPipeTile) {
            IMiningPipeTile machine = (IMiningPipeTile)tile;
            machine.onMiningPipeUpdate(at);
        }
    }

    public static void addListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.computeIfAbsent((Object)world, k -> new Long2ObjectOpenHashMap());
        Set set = (Set)map.computeIfAbsent(pos.m_121878_(), k -> new ObjectOpenHashSet());
        set.add(handle);
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && MiningPipeStructureCache.has(world, pos)) {
            handle.structureCacheAddition(tile);
        }
    }

    public static void removeListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Set set;
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null && (set = (Set)map.get(pos.m_121878_())) != null) {
            set.remove(handle);
        }
    }

    private static void notifyListenersAdd(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            BlockEntity tile = world.m_7702_(pos);
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(handle -> handle.structureCacheAddition(tile));
        }
    }

    private static void notifyListenersRemove(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(StructureHandle::structureCacheRemoval);
        }
    }

    public static void onWorldUnload(LevelAccessor world) {
        LOOKUP.remove((Object)((Level)world));
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.remove((Object)((Level)world));
        if (map != null) {
            map.forEach((k, v) -> v.forEach(StructureHandle::structureCacheRemoval));
        }
    }

    static {
        GTAPI.registerBlockUpdateHandler((world, pos, oldState, newState, flags) -> {
            if (oldState == newState) {
                return;
            }
            if ((flags & 1) == 0) {
                return;
            }
            StructureCache.DimensionEntry entry = (StructureCache.DimensionEntry)LOOKUP.get((Object)world);
            if (entry == null) {
                return;
            }
            LongSet controllerPos = entry.get(pos);
            if (controllerPos != null && controllerPos.size() > 0) {
                controllerPos.forEach(controller -> {
                    if (controller != pos.m_121878_()) {
                        MiningPipeStructureCache.refreshController(world, BlockPos.m_122022_((long)controller), pos);
                    }
                });
            }
        });
    }
}

