/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineItemHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;

public class BlockEntityProcessingArray
extends BlockEntityMultiMachine<BlockEntityProcessingArray>
implements IFilterableHandler {
    public BlockEntityProcessingArray(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.set(() -> new MultiMachineItemHandler<BlockEntityProcessingArray>(this){

            protected TrackedItemHandler<BlockEntityProcessingArray> createTrackedHandler(SlotType<?> type, BlockEntityProcessingArray tile) {
                if (type == SlotType.STORAGE) {
                    return new TrackedItemHandler((IGuiHandler)tile, type, 1, type.output, type.input, type.tester, 16);
                }
                return super.createTrackedHandler(type, (BlockEntityMachine)tile);
            }
        });
        this.recipeHandler.set(() -> new ParallelRecipeHandler<BlockEntityProcessingArray>(this, 1){
            IRecipeMap recipeMap;
            Tier tier;
            {
                this.recipeMap = null;
                this.tier = null;
            }

            @Override
            protected int maxSimultaneousRecipes() {
                return BlockEntityProcessingArray.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0).m_41613_()).orElse(0);
            }

            public void onMachineEvent(IMachineEvent event, Object ... data) {
                if (event == SlotType.STORAGE) {
                    BlockMachine machine;
                    BlockItem blockItem;
                    Block block;
                    IRecipeMap oldRecipeMap = this.recipeMap;
                    this.tier = null;
                    ItemStack stack = BlockEntityProcessingArray.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
                    Item item = stack.m_41720_();
                    if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof BlockMachine && (machine = (BlockMachine)block).getType() instanceof BasicMachine && machine.getType().getRecipeMap(machine.getTier()) != null) {
                        this.recipeMap = machine.getType().getRecipeMap(machine.getTier());
                        this.tier = machine.getTier();
                    }
                    if (oldRecipeMap != this.recipeMap) {
                        this.checkRecipe();
                    }
                }
                super.onMachineEvent(event, data);
            }

            public void init() {
                BlockMachine machine;
                BlockItem blockItem;
                Block block;
                ItemStack stack = BlockEntityProcessingArray.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
                Item item = stack.m_41720_();
                if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof BlockMachine && (machine = (BlockMachine)block).getType() instanceof BasicMachine && machine.getType().getRecipeMap(machine.getTier()) != null) {
                    this.recipeMap = machine.getType().getRecipeMap(machine.getTier());
                    this.tier = machine.getTier();
                }
                super.init();
            }

            public void checkRecipe() {
                if (this.getRecipeMap() == null) {
                    return;
                }
                super.checkRecipe();
            }

            public IRecipeMap getRecipeMap() {
                return this.recipeMap;
            }

            protected IRecipe cachedRecipe() {
                if (this.recipeMap == null) {
                    return null;
                }
                return super.cachedRecipe();
            }

            @Override
            public int getOverclock() {
                if (this.activeRecipe == null || this.tier == null) {
                    return 0;
                }
                int oc = 0;
                return oc;
            }

            @Override
            public CompoundTag serialize() {
                CompoundTag nbt = super.serialize();
                nbt.m_128359_("recipeMap", this.recipeMap.getId());
                return nbt;
            }

            @Override
            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                this.recipeMap = (IRecipeMap)GTAPI.get(RecipeMap.class, (String)nbt.m_128461_("recipeMap"));
            }
        });
    }

    public WidgetSupplier getInfoWidget() {
        return MultiSmelterInfoWidget.build().setPos(10, 10);
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int superDraw = super.drawInfo(instance, stack, renderer, left, top);
        if (this.getMachineState() == MachineState.ACTIVE && instance.drawActiveInfo()) {
            renderer.m_92883_(stack, "Concurrent Recipes: " + ((MultiSmelterInfoWidget)instance).concurrentRecipes, (float)left, (float)(top + 32), 0xFAFAFF);
            return superDraw + 8;
        }
        return superDraw;
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        if (slotType == SlotType.STORAGE) {
            BlockMachine machine;
            BlockItem blockItem;
            Block block;
            Item item = stack.m_41720_();
            return item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof BlockMachine && (machine = (BlockMachine)block).getType() instanceof BasicMachine && machine.getType().getRecipeMap(machine.getTier()) != null;
        }
        return true;
    }

    public static class MultiSmelterInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        int concurrentRecipes;

        protected MultiSmelterInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            BlockEntityProcessingArray m = (BlockEntityProcessingArray)this.gui.handler;
            this.gui.syncInt(() -> m.recipeHandler.map(r -> ((ParallelRecipeHandler)r).concurrentRecipes).orElse(0), i -> {
                this.concurrentRecipes = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return MultiSmelterInfoWidget.builder((a, b) -> new MultiSmelterInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

