/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityDrillingRigBase;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.worldgen.PlayerPlacedBlockSavedData;
import org.gtreimagined.gtlib.capability.machine.MultiMachineEnergyHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.TagUtils;

public class BlockEntityOreMiningRig
extends BlockEntityDrillingRigBase<BlockEntityOreMiningRig> {
    static ItemStack miningPickaxe = ItemStack.f_41583_;
    List<BlockPos> oresToMine = new ArrayList<BlockPos>();
    int progress = 0;
    RunningState runningState = RunningState.MINING;
    ItemStack[] currentDrops = null;

    public BlockEntityOreMiningRig(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (miningPickaxe.m_41619_()) {
            miningPickaxe = Items.f_42395_.m_7968_();
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)Enchantments.f_44987_, (Object)3), (ItemStack)miningPickaxe);
        }
    }

    @Override
    protected BlockEntityDrillingRigBase.MineResult mineBelowBlock(Level level, BlockPos pos, boolean dropBlock, ItemStack item) {
        boolean flag;
        boolean miningPipe;
        BlockState blockstate = level.m_8055_(pos);
        BlockState aboveBlockState = level.m_8055_(pos.m_7494_());
        if (aboveBlockState.m_60734_() != GT5RBlocks.MINING_PIPE && pos.m_123342_() + 1 != this.m_58899_().m_123342_()) {
            this.resetMiningPos();
            return BlockEntityDrillingRigBase.MineResult.PIPE_BROKEN;
        }
        if (blockstate.m_60800_((BlockGetter)level, pos) < 0.0f) {
            return BlockEntityDrillingRigBase.MineResult.FOUND_OBSTRUCTION;
        }
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
        }
        boolean bl = miningPipe = blockstate.m_60734_() == GT5RBlocks.MINING_PIPE || blockstate.m_60734_() == GT5RBlocks.MINING_PIPE_THIN;
        if (!miningPipe && !this.mineBlock(level, pos, dropBlock, item)) {
            return BlockEntityDrillingRigBase.MineResult.FOUND_OBSTRUCTION;
        }
        boolean bl2 = flag = blockstate.m_60734_() == GT5RBlocks.MINING_PIPE || level.m_6933_(pos, GT5RBlocks.MINING_PIPE.m_49966_(), 3, 512);
        if (flag && pos.m_123342_() + 1 < this.m_58899_().m_123342_()) {
            level.m_7731_(pos.m_7494_(), GT5RBlocks.MINING_PIPE_THIN.m_49966_(), 11);
        }
        return miningPipe ? BlockEntityDrillingRigBase.MineResult.FOUND_BOTTOM_MINING_PIPE : BlockEntityDrillingRigBase.MineResult.FOUND_BOTTOM;
    }

    @Override
    protected boolean mineBlock(Level level, BlockPos pos, boolean dropBlock, ItemStack item) {
        BlockEntity blockentity;
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return true;
        }
        BlockEntity blockEntity = blockentity = state.m_155947_() ? level.m_7702_(pos) : null;
        if (dropBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.currentDrops != null) {
                this.itemHandler.ifPresent(i -> i.addOutputs(this.currentDrops));
            } else {
                List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockentity, null, (ItemStack)item);
                if (this.itemHandler.map(i -> i.canOutputsFit((ItemStack[])drops.toArray(ItemStack[]::new))).orElse(false).booleanValue()) {
                    this.itemHandler.ifPresent(i -> i.addOutputs((ItemStack[])drops.toArray(ItemStack[]::new)));
                } else {
                    drops.forEach(i -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)i));
                }
            }
            state.m_60612_(serverLevel, pos, ItemStack.f_41583_);
        }
        return level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    public ItemStack getMiningPickaxe() {
        return miningPickaxe;
    }

    @Override
    protected void run(Level level, BlockPos pos, BlockState state) {
        if (this.runningState == RunningState.FINISHED) {
            return;
        }
        this.fillMineListIfEmpty(level);
        if (!this.oresToMine.isEmpty()) {
            BlockPos ore = this.oresToMine.get(0);
            if (this.currentDrops == null) {
                BlockState state1 = level.m_8055_(ore);
                BlockEntity blockentity = state1.m_155947_() ? level.m_7702_(ore) : null;
                this.currentDrops = Block.m_49874_((BlockState)state1, (ServerLevel)((ServerLevel)level), (BlockPos)ore, (BlockEntity)blockentity, null, (ItemStack)this.getMiningPickaxe()).toArray(new ItemStack[0]);
            }
            if (!this.energyHandler.map(e -> e.getEnergy() >= (long)this.euPerTick).orElse(false).booleanValue()) {
                this.runningState = RunningState.OUT_OF_ENERGY;
                if (this.getMachineState() == MachineState.ACTIVE) {
                    this.setMachineState(MachineState.IDLE);
                }
                if (this.progress > 0) {
                    this.progress = 0;
                }
                return;
            }
            if (this.progress == this.cycle && !this.fluidHandler.map(f -> f.getInputTanks().drain(Materials.DrillingFluid.getLiquid(100), IFluidHandler.FluidAction.SIMULATE).getAmount() == 100).orElse(false).booleanValue()) {
                this.runningState = RunningState.OUT_OF_DRILLING_FLUID;
                if (this.getMachineState() == MachineState.ACTIVE) {
                    this.setMachineState(MachineState.IDLE);
                }
                return;
            }
            if (this.progress == this.cycle && this.currentDrops != null && !this.itemHandler.map(i -> i.canOutputsFit(this.currentDrops)).orElse(false).booleanValue()) {
                this.runningState = RunningState.FULL;
                if (this.getMachineState() == MachineState.ACTIVE) {
                    this.setMachineState(MachineState.IDLE);
                }
                return;
            }
            this.setActive();
            this.runningState = RunningState.MINING;
            this.energyHandler.ifPresent(e -> e.extractEu((long)this.euPerTick, false));
            if (this.progress < this.cycle) {
                ++this.progress;
                return;
            }
            this.fluidHandler.ifPresent(f -> f.getInputTanks().drain(Materials.DrillingFluid.getLiquid(100), IFluidHandler.FluidAction.EXECUTE));
            this.mineBlock(level, ore, true, this.getMiningPickaxe());
            this.oresToMine.remove(0);
            this.progress = 0;
            this.currentDrops = null;
        } else {
            ++this.inactiveTicks;
            BlockState blockState = level.m_8055_(this.miningPos);
            if (blockState.m_60734_() == Blocks.f_50752_ || blockState.m_60734_() == Blocks.f_50626_) {
                this.runningState = RunningState.FINISHED;
                if (this.getMachineState() == MachineState.ACTIVE) {
                    this.setMachineState(MachineState.IDLE);
                }
                return;
            }
            this.foundBottom = false;
        }
    }

    public void afterStructureFormed() {
        super.afterStructureFormed();
        this.energyHandler.ifPresent(e -> {
            int tier = ((MultiMachineEnergyHandler)e).getAccumulatedPower().getIntegerId();
            this.euPerTick = 3 * (1 << (tier << 1));
            this.cycle = (int)(160.0 * (tier == 0 ? 2.0 : Math.pow(0.5, tier - 1))) * 3;
        });
    }

    private void fillMineListIfEmpty(Level level) {
        if (!this.oresToMine.isEmpty()) {
            return;
        }
        int startX = this.miningPos.m_123341_() >> 4 << 4;
        int startZ = this.miningPos.m_123343_() >> 4 << 4;
        for (int x = startX - 16; x < startX + 32; ++x) {
            for (int z = startZ - 16; z < startZ + 32; ++z) {
                this.tryAddOreBlockToMineList(level, new BlockPos(x, this.miningPos.m_123342_() + 1, z));
            }
        }
    }

    private void tryAddOreBlockToMineList(Level level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (PlayerPlacedBlockSavedData.getOrCreate(serverLevel).getPlacedPositions().contains(pos.m_121878_())) {
            return;
        }
        if (!blockstate.m_204336_(TagUtils.getForgelikeBlockTag((String)"bedrock_ores")) && !blockstate.m_204336_(TagUtils.getForgelikeBlockTag((String)"bedrock_small_ores")) && (blockstate.m_204336_(TagUtils.getForgelikeBlockTag((String)"ores")) || blockstate.m_204336_(TagUtils.getForgelikeBlockTag((String)"small_ores")))) {
            this.oresToMine.add(pos);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("runningState", this.runningState.ordinal());
        if (this.currentDrops != null) {
            ListTag drops = new ListTag();
            for (ItemStack drop : this.currentDrops) {
                drops.add((Object)drop.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("currentDrops", (Tag)drops);
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.progress = nbt.m_128451_("progress");
        this.runningState = RunningState.values()[nbt.m_128451_("runningState")];
        if (nbt.m_128441_("currentDrops")) {
            ListTag drops = nbt.m_128437_("currentDrops", 10);
            ItemStack[] stacks = new ItemStack[drops.size()];
            for (int i = 0; i < drops.size(); ++i) {
                stacks[i] = ItemStack.m_41712_((CompoundTag)drops.m_128728_(i));
            }
            this.currentDrops = stacks;
        }
    }

    public WidgetSupplier getInfoWidget() {
        return OreInfoWidget.build().setPos(10, 10);
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        OreInfoWidget oilInfoWidget = (OreInfoWidget)instance;
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            if (oilInfoWidget.runningState == RunningState.FINISHED) {
                renderer.m_92883_(stack, "Finished mining to bedrock", (float)left, (float)(top + 16), 0xFAFAFF);
                return 24;
            }
            return 16;
        }
        if (instance.drawActiveInfo() && oilInfoWidget.foundBottom && oilInfoWidget.runningState == RunningState.MINING) {
            renderer.m_92883_(stack, "Progress: " + instance.currentProgress + "/" + instance.maxProgress, (float)left, (float)(top + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "Ores left at y-level " + oilInfoWidget.currentPos.m_7494_().m_123342_() + ": " + oilInfoWidget.oresLeft, (float)left, (float)(top + 16), 0xFAFAFF);
            return 24;
        }
        return 8;
    }

    static enum RunningState {
        MINING,
        FINISHED,
        OUT_OF_DRILLING_FLUID,
        FULL,
        OUT_OF_ENERGY;

    }

    public static class OreInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        BlockPos currentPos;
        boolean stopped;
        boolean foundBottom;
        RunningState runningState;
        int oresLeft;

        protected OreInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            BlockEntityOreMiningRig m = (BlockEntityOreMiningRig)this.gui.handler;
            this.gui.syncLong(() -> m.miningPos.m_121878_(), l -> {
                this.currentPos = BlockPos.m_122022_((long)l);
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncBoolean(() -> m.stopped, s -> {
                this.stopped = s;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncBoolean(() -> m.foundBottom, b -> {
                this.foundBottom = b;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.progress, i -> {
                this.currentProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.cycle, i -> {
                this.maxProgress = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.runningState.ordinal(), i -> {
                this.runningState = RunningState.values()[i];
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.oresToMine.size(), i -> {
                this.oresLeft = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return OreInfoWidget.builder((a, b) -> new OreInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }
    }
}

