/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.client.scene.TrackedDummyWorld;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityLongDistancePipeEndpoint
extends BlockEntityBasicMultiMachine<BlockEntityLongDistancePipeEndpoint> {
    BlockEntityLongDistancePipeEndpoint target = null;
    BlockEntityLongDistancePipeEndpoint sender = null;
    LongList successfulPositions;

    public BlockEntityLongDistancePipeEndpoint(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has("eu")) {
            this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntityLongDistancePipeEndpoint>(this, false){

                public long insertEu(long voltage, boolean simulate) {
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).target == null) {
                        return 0L;
                    }
                    if (!this.checkVoltage(voltage)) {
                        return 0L;
                    }
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).target.getNeighbor() == null) {
                        return 0L;
                    }
                    IEnergyHandler handler = ((BlockEntityLongDistancePipeEndpoint)this.tile).target.getNeighbor().getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, ((BlockEntityLongDistancePipeEndpoint)this.tile).target.getFacing().m_122424_()).resolve().orElse(null);
                    if (handler == null) {
                        return 0L;
                    }
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).successfulPositions == null) {
                        return 0L;
                    }
                    int loss = Math.round((float)((BlockEntityLongDistancePipeEndpoint)this.tile).successfulPositions.size() * 0.125f);
                    if ((long)loss >= voltage) {
                        return 0L;
                    }
                    return handler.insertEu(Math.max(0L, voltage - (long)loss), simulate) + (long)loss;
                }

                public long availableAmpsInput(long voltage) {
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).target == null) {
                        return 0L;
                    }
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).target.getNeighbor() == null) {
                        return 0L;
                    }
                    IEnergyHandler handler = ((BlockEntityLongDistancePipeEndpoint)this.tile).target.getNeighbor().getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, ((BlockEntityLongDistancePipeEndpoint)this.tile).target.getFacing().m_122424_()).resolve().orElse(null);
                    if (handler == null) {
                        return 0L;
                    }
                    if (((BlockEntityLongDistancePipeEndpoint)this.tile).successfulPositions == null) {
                        return 0L;
                    }
                    int loss = Math.round((float)((BlockEntityLongDistancePipeEndpoint)this.tile).successfulPositions.size() * 0.125f);
                    return handler.availableAmpsInput(Math.max(0L, voltage - (long)loss));
                }

                public long getCapacity() {
                    return 0L;
                }

                protected boolean checkVoltage(long voltage) {
                    return voltage <= this.getInputVoltage();
                }
            });
        }
    }

    protected Block getPipeline() {
        Block block;
        if (this.type == GT5RMachines.LONG_DISTANCE_FLUID_ENDPOINT) {
            return GT5RBlocks.LONG_DIST_FLUID_PIPE;
        }
        if (this.type == GT5RMachines.LONG_DISTANCE_ITEM_ENDPOINT) {
            return GT5RBlocks.LONG_DIST_ITEM_PIPE;
        }
        if (this.type == GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT && (block = (Block)GT5Reimagined.get(BlockCasing.class, "long_distance_wire_" + this.tier.getId())) != null) {
            return block;
        }
        return Blocks.f_50090_;
    }

    public boolean checkStructure() {
        ++this.checkingStructure;
        boolean fail = false;
        boolean succeed = false;
        Direction to = this.getFacing();
        BlockPos.MutableBlockPos mut = this.m_58899_().m_122032_();
        this.successfulPositions = new LongArrayList();
        int pipelinesFound = 0;
        boolean switchDirection = false;
        while (true) {
            mut.m_122173_(to);
            BlockState state = this.m_58904_().m_8055_((BlockPos)mut);
            if (state.m_60734_() == this.m_58900_().m_60734_() && pipelinesFound > 0) {
                BlockEntityLongDistancePipeEndpoint endpoint;
                Direction compare = switchDirection ? to.m_122424_() : to;
                BlockEntity blockEntity = this.m_58904_().m_7702_((BlockPos)mut);
                if (!(blockEntity instanceof BlockEntityLongDistancePipeEndpoint) || (endpoint = (BlockEntityLongDistancePipeEndpoint)blockEntity).getFacing() != compare) break;
                endpoint.validStructure = true;
                if (switchDirection) {
                    this.sender = endpoint;
                    this.sender.target = this;
                } else {
                    this.target = endpoint;
                    this.target.sender = this;
                }
                this.successfulPositions.add(mut.m_121878_());
                succeed = true;
                break;
            }
            if (state.m_60734_() == this.getPipeline()) {
                this.successfulPositions.add(mut.m_121878_());
                ++pipelinesFound;
                continue;
            }
            mut.m_122173_(to.m_122424_());
            if (mut.equals((Object)this.m_58899_())) {
                if (switchDirection) break;
                switchDirection = true;
                mut = this.m_58899_().m_122032_();
                to = this.getFacing().m_122424_();
                continue;
            }
            int failed = 0;
            int succeeded = 0;
            Direction oldTo = to;
            for (Direction dir : Direction.values()) {
                if (dir == oldTo || dir == oldTo.m_122424_()) continue;
                BlockState state2 = this.m_58904_().m_8055_(mut.m_7949_().m_142300_(dir));
                if (state2.m_60734_() == this.getPipeline()) {
                    if (succeeded == 0) {
                        to = dir;
                    }
                    ++succeeded;
                    continue;
                }
                ++failed;
            }
            if (failed != 4 && succeeded <= true) continue;
            if (switchDirection) break;
            switchDirection = true;
            mut = this.m_58899_().m_122032_();
            to = this.getFacing().m_122424_();
            this.successfulPositions = new LongArrayList();
        }
        --this.checkingStructure;
        boolean bl = this.validStructure = succeed && pipelinesFound > 0;
        if (this.validStructure) {
            if (this.f_58857_ instanceof TrackedDummyWorld) {
                StructureCache.add((Level)this.f_58857_, (BlockPos)this.f_58858_, (LongList)this.successfulPositions);
                StructureCache.validate((Level)this.f_58857_, (BlockPos)this.f_58858_, (LongList)this.successfulPositions, (int)this.maxShares());
                --this.checkingStructure;
                return true;
            }
            if (this.onStructureFormed() && StructureCache.validate((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (LongList)this.successfulPositions, (int)this.maxShares())) {
                if (this.isServerSide()) {
                    this.afterStructureFormed();
                    if (this.machineState != MachineState.ACTIVE && this.machineState != MachineState.DISABLED) {
                        this.setMachineState(MachineState.IDLE);
                    }
                }
                this.sidedSync(true);
                StructureCache.add((Level)this.f_58857_, (BlockPos)this.m_58899_(), (LongList)this.successfulPositions);
            } else {
                this.validStructure = false;
            }
        }
        if (!this.validStructure) {
            this.successfulPositions.clear();
        }
        return this.validStructure;
    }

    public void onBlockUpdate(BlockPos pos) {
        if (this.checkingStructure > 0) {
            return;
        }
        if (this.validStructure) {
            BlockState state = this.m_58904_().m_8055_(pos);
            if (this.successfulPositions != null && this.successfulPositions.contains(pos.m_121878_()) && state.m_60734_() != this.getPipeline()) {
                this.invalidateStructure();
            }
        } else {
            this.checkStructure();
        }
    }

    public BlockEntity getNeighbor() {
        return this.getCachedBlockEntity(this.getFacing());
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.successfulPositions != null) {
            this.successfulPositions.clear();
        }
        if (this.target != null) {
            this.target.sender = null;
            this.target.invalidateStructure();
            this.target = null;
        }
        if (this.sender != null) {
            this.sender.target = null;
            this.sender.invalidateStructure();
            this.sender = null;
        }
    }

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
        if (side == this.getFacing().m_122424_() && (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.has("fluid") || cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.has("item"))) {
            BlockEntity sideBE;
            if (this.target != null && (sideBE = this.target.getCachedBlockEntity(this.target.getFacing())) != null) {
                return sideBE.getCapability(cap, this.target.getFacing().m_122424_());
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }
}

