/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.machine.caps.SecondaryMultiFluidHandler;
import org.gtreimagined.gt5r.machine.recipe.FusionRecipe;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.DefaultHeatHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.texture.Texture;

public class BlockEntityFusionReactor
extends BlockEntityMultiMachine<BlockEntityFusionReactor> {
    Display display = Display.REGULAR;

    public BlockEntityFusionReactor(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatHandler.set(() -> new DefaultHeatHandler((BlockEntityBase)this, 262144, 8192, 0));
        this.fluidHandler.set(() -> new SecondaryMultiFluidHandler<BlockEntityFusionReactor>(this));
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityFusionReactor>(this){
            boolean consumedStartEu;
            {
                this.consumedStartEu = false;
            }

            public boolean consumePower(boolean simulate) {
                boolean run;
                if (this.activeRecipe == null) {
                    return false;
                }
                if (!this.consumedStartEu) {
                    boolean tConsumedStartEu = BlockEntityFusionReactor.this.energyHandler.map(e -> e.extractEu((long)this.activeRecipe.getSpecialValue(), true) == (long)this.activeRecipe.getSpecialValue()).orElse(false);
                    if (tConsumedStartEu) {
                        if (!simulate) {
                            BlockEntityFusionReactor.this.energyHandler.ifPresent(e -> e.extractEu((long)this.activeRecipe.getSpecialValue(), false));
                        }
                        this.consumedStartEu = true;
                    } else {
                        return false;
                    }
                }
                boolean bl = run = super.consumePower(simulate) && this.consumedStartEu;
                if (run) {
                    BlockEntityFusionReactor.this.heatHandler.ifPresent(h -> h.insert(((FusionRecipe)this.activeRecipe).getHuOutput(), simulate));
                }
                return run;
            }

            protected MachineState tickRecipe() {
                IRecipe oldActive = this.activeRecipe;
                MachineState oldState = ((BlockEntityFusionReactor)this.tile).getMachineState();
                MachineState superState = super.tickRecipe();
                if (this.consumedStartEu && oldActive != null && (oldActive != this.activeRecipe || oldState == MachineState.ACTIVE && superState != MachineState.ACTIVE)) {
                    this.consumedStartEu = false;
                }
                return superState;
            }

            public CompoundTag serialize() {
                CompoundTag nbt = super.serialize();
                nbt.m_128379_("consumedStartEu", this.consumedStartEu);
                return nbt;
            }

            public void deserialize(CompoundTag nbt) {
                super.deserialize(nbt);
                this.consumedStartEu = nbt.m_128471_("consumedStartEu");
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.fluidHandler.ifPresent(f -> {
            if (!(f instanceof SecondaryMultiFluidHandler)) {
                return;
            }
            SecondaryMultiFluidHandler mf = (SecondaryMultiFluidHandler)((Object)f);
            if (mf.getSecondaryInputTanks() == null) {
                return;
            }
            this.heatHandler.ifPresent(h -> {
                if (h.getHeat() >= 30) {
                    long inserted;
                    int heatMultiplier = h.getHeat() / 30;
                    FluidTank coolantTank = mf.getSecondaryInputTanks().getTank(mf.getSecondaryInputTanks().getFirstAvailableTank(Materials.Helium.getGas(1), true));
                    if (coolantTank != null && coolantTank.drain(Materials.Helium.getGas(heatMultiplier = Math.min(heatMultiplier, coolantTank.getFluidAmount())), IFluidHandler.FluidAction.SIMULATE).getAmount() == heatMultiplier && mf.getSecondaryOutputTanks() != null && mf.getSecondaryOutputTanks().getTanks() >= 1 && (inserted = (long)mf.getSecondaryOutputTanks().fill(Materials.HotHelium.getGas(heatMultiplier), IFluidHandler.FluidAction.SIMULATE)) >= 1L) {
                        heatMultiplier = (int)Math.min((long)heatMultiplier, inserted);
                        coolantTank.drain(Materials.Helium.getGas(heatMultiplier), IFluidHandler.FluidAction.EXECUTE);
                        mf.getSecondaryOutputTanks().fill(Materials.HotHelium.getGas(heatMultiplier), IFluidHandler.FluidAction.EXECUTE);
                        h.extract(heatMultiplier * 30, false);
                    }
                }
            });
        });
    }

    public Display getDisplay() {
        return this.display;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("display", this.display.ordinal());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.display = Display.values()[tag.m_128451_("display")];
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            int[] data = ev.data;
            if (data[1] == 0) {
                this.display = Display.REGULAR;
            } else if (data[1] == 1) {
                this.display = Display.MIDDLE;
            } else if (data[1] == 2) {
                this.display = Display.TOP_BOTTOM;
            }
        }
    }

    public Texture getTextureForHatches(Direction dir, BlockPos hatchPos) {
        return new Texture("gt5r", "block/casing/fusion_1");
    }

    public int guiHeight() {
        return 182;
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        return 0;
    }

    public static enum Display {
        REGULAR,
        MIDDLE,
        TOP_BOTTOM;

    }
}

