/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityElectricBlastFurnace
extends BlockEntityMultiMachine<BlockEntityElectricBlastFurnace> {
    private BlockCoil.CoilData coilData;

    public BlockEntityElectricBlastFurnace(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityElectricBlastFurnace>(this){

            protected void calculateDurations() {
                super.calculateDurations();
                this.maxProgress = this.activeRecipe.getDuration();
                this.overclock = 0;
                long voltage = BlockEntityElectricBlastFurnace.this.getMaxInputVoltage();
                int tier = Math.max(1, Utils.getVoltageTier((long)voltage));
                int recipeTier = Utils.getVoltageTier((long)this.activeRecipe.getPower());
                if (recipeTier == tier) {
                    BlockEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower();
                    return;
                }
                if (BlockEntityElectricBlastFurnace.this.coilData != null && BlockEntityElectricBlastFurnace.this.coilData.heat() >= this.activeRecipe.getSpecialValue()) {
                    int heatDiv = (BlockEntityElectricBlastFurnace.this.coilData.heat() - this.activeRecipe.getSpecialValue()) / 900;
                    if (this.activeRecipe.getPower() <= 16L) {
                        BlockEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower() * (1L << tier - 1) * (1L << tier - 1);
                        this.maxProgress = this.activeRecipe.getDuration() / (1 << tier - 1);
                    } else {
                        BlockEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower();
                        this.maxProgress = this.activeRecipe.getDuration();
                        int i = 2;
                        while (BlockEntityElectricBlastFurnace.this.EUt <= Ref.V[tier - 1]) {
                            BlockEntityElectricBlastFurnace.this.EUt *= 4L;
                            this.maxProgress /= heatDiv >= i ? 4 : 2;
                            i += 2;
                        }
                        if (heatDiv > 0) {
                            BlockEntityElectricBlastFurnace.this.EUt = (long)((double)BlockEntityElectricBlastFurnace.this.EUt * Math.pow(0.95, heatDiv));
                        }
                    }
                }
            }

            public long getPower() {
                return BlockEntityElectricBlastFurnace.this.EUt;
            }

            protected boolean validateRecipe(IRecipe r) {
                return super.validateRecipe(r) && BlockEntityElectricBlastFurnace.this.coilData != null && BlockEntityElectricBlastFurnace.this.coilData.heat() >= r.getSpecialValue();
            }
        });
    }

    public boolean onStructureFormed() {
        super.onStructureFormed();
        return true;
    }

    public void setCoilData(BlockCoil.CoilData coilData) {
        this.coilData = coilData;
    }

    public BlockCoil.CoilData getCoilData() {
        return this.coilData;
    }
}

