/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.int3;

public class BlockEntityBedrockDrill
extends BlockEntityMultiMachine<BlockEntityBedrockDrill> {
    int bedrockOresFound = 0;
    IRecipe recipe;
    int oreChance = 0;
    Item cobble = Items.f_151035_;
    ItemStack mainOutput = ItemStack.f_41583_;
    List<Pair<ItemStack, Integer>> byProducts = new ArrayList<Pair<ItemStack, Integer>>();
    ItemStack cachedOutput = ItemStack.f_41583_;
    int inActiveTicks = 0;

    public BlockEntityBedrockDrill(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityBedrockDrill>(this){

            public void onServerUpdate() {
            }
        });
    }

    public boolean onStructureFormed() {
        this.recipe = null;
        this.oreChance = 0;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos behind = new int3(this.m_58899_(), this.getFacing()).back(1).below(2).m_7949_();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos orePos = behind.m_122032_().m_122184_(x, 0, z).m_7949_();
                BlockState oreBlock = this.f_58857_.m_8055_(orePos);
                if (oreBlock.m_204336_(TagUtils.getForgelikeBlockTag((String)"bedrock_ores"))) {
                    this.oreChance += 2;
                    if (this.recipe != null) continue;
                    this.recipe = RecipeMaps.BEDROCK_DRILL.find(new ItemStack[]{new ItemStack((ItemLike)oreBlock.m_60734_())}, new FluidStack[]{Materials.Lubricant.getLiquid(100)}, Tier.LUV, r -> true);
                    continue;
                }
                if (!oreBlock.m_204336_(TagUtils.getForgelikeBlockTag((String)"bedrock_small_ores"))) continue;
                ++this.oreChance;
                if (this.recipe != null) continue;
                this.recipe = RecipeMaps.BEDROCK_DRILL.find(new ItemStack[]{new ItemStack((ItemLike)oreBlock.m_60734_())}, new FluidStack[]{Materials.Lubricant.getLiquid(100)}, Tier.LUV, r -> true);
            }
        }
        if (this.recipe == null || this.oreChance <= 0) {
            return false;
        }
        ItemStack[] outputs = this.recipe.getOutputItems(false);
        if (this.recipe.getOutputChances() == null) {
            return false;
        }
        this.mainOutput = outputs[0];
        for (int i = 1; i < outputs.length - 2; ++i) {
            ItemStack output = outputs[i];
            this.byProducts.add((Pair<ItemStack, Integer>)Pair.of((Object)output, (Object)this.recipe.getOutputChances()[i]));
        }
        return super.onStructureFormed();
    }

    public boolean checkStructure() {
        this.bedrockOresFound = 0;
        return super.checkStructure();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.inActiveTicks > 40) {
            if (this.getMachineState() == MachineState.ACTIVE) {
                this.setMachineState(MachineState.IDLE);
            }
            this.inActiveTicks = 0;
        }
        if (!this.cachedOutput.m_41619_()) {
            if (this.itemHandler.map(i -> i.canOutputsFit(new ItemStack[]{this.cachedOutput})).orElse(false).booleanValue()) {
                this.itemHandler.ifPresent(i -> i.addOutputs(new ItemStack[]{this.cachedOutput}));
                this.cachedOutput = ItemStack.f_41583_;
            }
            return;
        }
        if (this.recipe != null && this.energyHandler.map(e -> e.getEnergy() >= this.recipe.getPower()).orElse(false).booleanValue()) {
            boolean consumeFluid = this.fluidHandler.map(h -> {
                List fluidInputs = h.consumeAndReturnInputs(this.recipe.getInputFluids(), true);
                return !fluidInputs.isEmpty();
            }).orElse(true);
            if (consumeFluid && !this.mainOutput.m_41619_()) {
                if (level.m_5822_().nextInt(1000) == 0) {
                    int index;
                    List<StoneType> types = GTAPI.all(StoneType.class).stream().filter(s -> s instanceof CobbleStoneType || s == VanillaStoneTypes.BEDROCK || s == VanillaStoneTypes.STONE).toList();
                    StoneType type = types.get(index = level.m_5822_().nextInt(types.size()));
                    if (type == VanillaStoneTypes.DEEPSLATE) {
                        this.cobble = Items.f_151035_;
                    } else if (type == VanillaStoneTypes.STONE) {
                        this.cobble = Items.f_42594_;
                    } else if (type instanceof CobbleStoneType) {
                        CobbleStoneType cobbleStoneType = (CobbleStoneType)type;
                        this.cobble = cobbleStoneType.getBlock("cobble").m_5456_();
                    }
                }
                int selector = level.m_5822_().nextInt(128);
                ItemStack output = new ItemStack((ItemLike)this.cobble);
                if (selector < this.oreChance) {
                    output = level.m_5822_().nextInt(32) == 0 && !this.byProducts.isEmpty() ? (ItemStack)this.byProducts.get(level.m_5822_().nextInt(this.byProducts.size())).first() : this.mainOutput;
                } else if (level.m_5822_().nextInt(1000) == 0) {
                    output = GTMaterialTypes.DUST.get(Materials.Bedrock, 1);
                } else if (level.m_46472_().m_135782_().equals((Object)Level.f_46429_.m_135782_())) {
                    output = new ItemStack((ItemLike)Items.f_42048_);
                }
                ItemStack finalOutput = output;
                if (this.itemHandler.map(i -> i.canOutputsFit(new ItemStack[]{finalOutput})).orElse(false).booleanValue()) {
                    this.itemHandler.ifPresent(i -> i.addOutputs(new ItemStack[]{finalOutput}));
                } else {
                    this.cachedOutput = output;
                }
                this.energyHandler.ifPresent(e -> e.extractEu(this.recipe.getPower(), false));
                this.fluidHandler.ifPresent(f -> f.consumeAndReturnInputs(this.recipe.getInputFluids(), false));
                this.inActiveTicks = 0;
                if (this.getMachineState() == MachineState.IDLE) {
                    this.setMachineState(MachineState.ACTIVE);
                }
            } else {
                this.setInActive();
            }
        } else {
            this.setInActive();
        }
    }

    private void setInActive() {
        if (this.getMachineState() == MachineState.ACTIVE) {
            ++this.inActiveTicks;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.cachedOutput.m_41619_()) {
            tag.m_128365_("cachedOutput", (Tag)this.cachedOutput.m_41739_(new CompoundTag()));
        }
        if (this.cobble != null) {
            tag.m_128359_("cobble", RegistryUtils.getIdFromItem((Item)this.cobble).toString());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("cachedOutput")) {
            this.cachedOutput = ItemStack.m_41712_((CompoundTag)tag.m_128469_("cachedOutput"));
        }
        if (tag.m_128441_("cobble")) {
            this.cobble = RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(tag.m_128461_("cobble")));
        }
    }

    @Generated
    public int getBedrockOresFound() {
        return this.bedrockOresFound;
    }

    @Generated
    public void setBedrockOresFound(int bedrockOresFound) {
        this.bedrockOresFound = bedrockOresFound;
    }
}

