/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.block.BlockFakeTile;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class BlockColoredWall
extends BlockFakeTile
implements IColorHandler {
    final Material material;

    public BlockColoredWall(String domain, Material material, BlockBehaviour.Properties properties) {
        super(domain, material.getId() + "_wall", properties);
        this.material = material;
    }

    public BlockColoredWall(String domain, Material material) {
        this(domain, material, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76279_).m_60913_(1.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60999_());
    }

    public Material getMaterial() {
        return this.material;
    }

    public Texture[] getTextures() {
        Texture side = this.material == GTLibMaterials.Wood ? new Texture("gt5r", "block/casing/wall/wood") : new Texture("gt5r", "block/casing/wall/metal");
        Texture overlay = new Texture("gt5r", "block/machine/empty");
        Texture sideOverlay = this.material == GTLibMaterials.Wood ? new Texture("gt5r", "block/casing/wall/wood_overlay_side") : overlay;
        return new Texture[]{side, side, side, side, side, side, overlay, overlay, sideOverlay, sideOverlay, sideOverlay, sideOverlay};
    }

    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }
}

