/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.net.Message;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MessageOpenHistory
implements Message {
    private List<Death> deaths;

    public MessageOpenHistory() {
    }

    public MessageOpenHistory(List<Death> deaths) {
        this.deaths = deaths;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClientSide(NetworkEvent.Context context) {
        if (this.deaths.size() > 0) {
            Minecraft.m_91087_().m_91152_((Screen)new DeathHistoryScreen(this.deaths));
        } else {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("message.corpse.no_death_history"), true);
        }
    }

    public MessageOpenHistory fromBytes(FriendlyByteBuf buf) {
        CompoundTag compound = buf.m_130260_();
        ListTag list = compound.m_128437_("Deaths", 10);
        this.deaths = new ArrayList<Death>();
        for (int i = 0; i < list.size(); ++i) {
            this.deaths.add(Death.fromNBT(list.m_128728_(i)));
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (Death d : this.deaths) {
            CompoundTag c = d.toNBT(false);
            list.add((Object)c);
        }
        compound.m_128365_("Deaths", (Tag)list);
        buf.m_130079_(compound);
    }
}

