/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import de.maxhenkel.corpse.net.MessageOpenAdditionalItems;
import de.maxhenkel.corpse.net.MessageTransferItems;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CorpseInventoryScreen
extends ScreenBase<CorpseInventoryContainer> {
    public static final ResourceLocation CORPSE_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/inventory_corpse.png");
    public static final TranslatableComponent TRANSFER_ITEMS = new TranslatableComponent("button.corpse.transfer_items");
    public static final TranslatableComponent ADDITIONAL_ITEMS = new TranslatableComponent("button.corpse.additional_items");
    public static final Button.OnPress PRESS_TRANSFER_ITEMS = b -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageTransferItems());
    public static final Button.OnPress PRESS_ADDITIONAL_ITEMS = b -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenAdditionalItems());
    private static final int PADDING = 7;
    private static final int BUTTON_HEIGHT = 20;
    private Inventory playerInventory;
    private CorpseEntity corpse;
    private Button takeItems;
    private Button additionalItems;

    public CorpseInventoryScreen(CorpseEntity corpse, Inventory playerInventory, CorpseInventoryContainer container, Component title) {
        super(CORPSE_GUI_TEXTURE, container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.corpse = corpse;
        this.f_97726_ = 176;
        this.f_97727_ = 245;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    public void m_7856_() {
        super.m_7856_();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_169413_();
        CorpseEntity corpse = ((CorpseInventoryContainer)this.f_97732_).getCorpse();
        if (!corpse.isMainInventoryEmpty() && !corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = this.addLeftButton((Component)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = this.addRightButton((Component)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        } else if (!corpse.isMainInventoryEmpty()) {
            this.takeItems = this.addCenterButton((Component)TRANSFER_ITEMS, PRESS_TRANSFER_ITEMS);
            this.additionalItems = null;
        } else if (!corpse.isAdditionalInventoryEmpty()) {
            this.takeItems = null;
            this.additionalItems = this.addCenterButton((Component)ADDITIONAL_ITEMS, PRESS_ADDITIONAL_ITEMS);
        }
        if (this.takeItems != null) {
            this.takeItems.f_93623_ = ((CorpseInventoryContainer)this.f_97732_).isEditable();
        }
    }

    private Button addLeftButton(Component text, Button.OnPress pressable) {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 7, this.f_97736_ + 120, 80, 20, text, pressable));
    }

    private Button addRightButton(Component text, Button.OnPress pressable) {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + this.f_97726_ - 80 - 7, this.f_97736_ + 120, 80, 20, text, pressable));
    }

    private Button addCenterButton(Component text, Button.OnPress pressable) {
        return (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + this.f_97726_ / 2 - 50, this.f_97736_ + 120, 100, 20, text, pressable));
    }

    @Override
    public void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92889_(matrixStack, this.corpse.m_5446_(), 7.0f, 7.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.playerInventory.m_5446_(), 7.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }
}

