/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ItemListInventory;
import de.maxhenkel.corpse.corelib.inventory.LockedSlot;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.ITransferrable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class CorpseAdditionalContainer
extends CorpseContainerBase
implements ITransferrable {
    private PlayerMainInvWrapper playerWrapper;

    public CorpseAdditionalContainer(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super(Main.CONTAINER_TYPE_CORPSE_ADDITIONAL_ITEMS, id, playerInventory, corpse, editable, history);
        this.inventory = new ItemListInventory(corpse.getDeath().getAdditionalItems());
        this.playerWrapper = new PlayerMainInvWrapper(playerInventory);
        this.setSlots(0);
    }

    public void setSlots(int start) {
        this.f_38839_.clear();
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 9; ++k) {
                int index = start + k + j * 9;
                if (index < this.inventory.m_6643_()) {
                    this.m_38897_(new LockedSlot(this.inventory, index, 8 + k * 18, 19 + j * 18, true, !this.editable));
                    continue;
                }
                this.m_38897_(new LockedSlot((Container)new SimpleContainer(1), 0, 8 + k * 18, 19 + j * 18, true, true));
            }
        }
        this.addPlayerInventorySlots();
        this.m_38946_();
    }

    @Override
    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        block0: for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            for (int j = 0; j < this.playerWrapper.getSlots(); ++j) {
                stack = this.playerWrapper.insertItem(j, stack, false);
                this.inventory.m_6836_(i, stack);
                if (stack.m_41619_()) continue block0;
            }
        }
    }

    @Override
    public int getInvOffset() {
        return 82;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }
}

