/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains;

import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class HonkPacket
extends SimplePacketBase {
    UUID trainId;
    boolean isHonk;

    public HonkPacket() {
    }

    public HonkPacket(Train train, boolean isHonk) {
        this.trainId = train.id;
        this.isHonk = isHonk;
    }

    public HonkPacket(FriendlyByteBuf buffer) {
        this.trainId = buffer.m_130259_();
        this.isHonk = buffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.writeBoolean(this.isHonk);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            boolean clientSide = sender == null;
            Train train = Create.RAILWAYS.sided((LevelAccessor)(clientSide ? null : sender.f_19853_)).trains.get(this.trainId);
            if (train == null) {
                return;
            }
            if (clientSide) {
                train.honkTicks = this.isHonk ? (train.honkTicks == 0 ? 20 : 13) : (train.honkTicks > 5 ? 6 : 0);
            } else {
                AllAdvancements.TRAIN_WHISTLE.awardTo((Player)sender);
                AllPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new HonkPacket(train, this.isHonk));
            }
        });
        return true;
    }

    public static class Serverbound
    extends HonkPacket {
        public Serverbound(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public Serverbound(Train train, boolean isHonk) {
            super(train, isHonk);
        }
    }
}

