/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkScreen;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class DisplayLinkBlock
extends WrenchableDirectionalBlock
implements IBE<DisplayLinkBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public DisplayLinkBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState placed = super.m_5573_(context);
        placed = (BlockState)placed.m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
        return (BlockState)placed.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(placed, context.m_43725_(), context.m_8083_())));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public static void notifyGatherers(LevelAccessor level, BlockPos pos) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, DisplayLinkBlockEntity::tickSource);
    }

    public static <T extends DisplaySource> void sendToGatherers(LevelAccessor level, BlockPos pos, BiConsumer<DisplayLinkBlockEntity, T> callback, Class<T> type) {
        DisplayLinkBlock.forEachAttachedGatherer(level, pos, dgte -> {
            if (type.isInstance(dgte.activeSource)) {
                callback.accept((DisplayLinkBlockEntity)dgte, (Object)dgte.activeSource);
            }
        });
    }

    private static void forEachAttachedGatherer(LevelAccessor level, BlockPos pos, Consumer<DisplayLinkBlockEntity> callback) {
        for (Direction d : Iterate.directions) {
            BlockEntity blockEntity;
            BlockPos offsetPos = pos.m_142300_(d);
            BlockState blockState = level.m_8055_(offsetPos);
            if (!AllBlocks.DISPLAY_LINK.has(blockState) || !((blockEntity = level.m_7702_(offsetPos)) instanceof DisplayLinkBlockEntity)) continue;
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)blockEntity;
            if (dlbe.activeSource == null || dlbe.getDirection() != d.m_122424_()) continue;
            callback.accept(dlbe);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)pos.m_142300_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_()))) {
            DisplayLinkBlock.sendToGatherers((LevelAccessor)worldIn, fromPos, (dlte, p) -> dlte.tickSource(), RedstonePowerDisplaySource.class);
        }
        boolean powered = this.shouldBePowered(state, worldIn, pos);
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != powered) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            if (!powered) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, DisplayLinkBlockEntity::onNoLongerPowered);
            }
        }
    }

    private boolean shouldBePowered(BlockState state, Level worldIn, BlockPos pos) {
        boolean powered = false;
        for (Direction d : Iterate.directions) {
            if (d.m_122424_() == state.m_61143_((Property)f_52588_) || worldIn.m_46681_(pos.m_142300_(d), d) == 0) continue;
            powered = true;
            break;
        }
        return powered;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWERED}));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        if (pPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> this.displayScreen((DisplayLinkBlockEntity)be, pPlayer)));
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(DisplayLinkBlockEntity be, Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        if (be.targetOffset.equals((Object)BlockPos.f_121853_)) {
            player.m_5661_((Component)Lang.translateDirect("display_link.invalid", new Object[0]), true);
            return;
        }
        ScreenOpener.open(new DisplayLinkScreen(be));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.DATA_GATHERER.get((Direction)pState.m_61143_((Property)f_52588_));
    }

    @Override
    public Class<DisplayLinkBlockEntity> getBlockEntityClass() {
        return DisplayLinkBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends DisplayLinkBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.DISPLAY_LINK.get();
    }
}

