/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerRenderer;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlazeBurnerMovementBehaviour
implements MovementBehaviour {
    @Override
    public boolean renderAsNormalBlockEntity() {
        return false;
    }

    @Override
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    @Override
    public void tick(MovementContext context) {
        if (!context.world.m_5776_()) {
            return;
        }
        if (!this.shouldRender(context)) {
            return;
        }
        Random r = context.world.m_5822_();
        Vec3 c = context.position;
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, r, 0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0 && context.motion.m_82553_() < 0.015625) {
            context.world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        LerpedFloat headAngle = this.getHeadAngle(context);
        boolean quickTurn = this.shouldRenderHat(context) && !Mth.m_14082_((double)context.relativeMotion.m_82553_(), (double)0.0);
        headAngle.chase(headAngle.getValue() + AngleHelper.getShortestAngleDiff(headAngle.getValue(), this.getTargetAngle(context)), 0.5, quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp(5.0));
        headAngle.tickChaser();
    }

    public void invalidate(MovementContext context) {
        context.data.m_128473_("Conductor");
    }

    private boolean shouldRender(MovementContext context) {
        return context.state.m_61145_(BlazeBurnerBlock.HEAT_LEVEL).orElse(BlazeBurnerBlock.HeatLevel.NONE) != BlazeBurnerBlock.HeatLevel.NONE;
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat)) {
            context.temporaryData = LerpedFloat.angular().startWithValue(this.getTargetAngle(context));
        }
        return (LerpedFloat)context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity;
        if (this.shouldRenderHat(context) && !Mth.m_14082_((double)context.relativeMotion.m_82553_(), (double)0.0) && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            float angle = AngleHelper.deg(-Mth.m_14136_((double)context.relativeMotion.f_82479_, (double)context.relativeMotion.f_82481_));
            return cce.getInitialOrientation().m_122434_() == Direction.Axis.X ? angle + 180.0f : angle;
        }
        Entity player = Minecraft.m_91087_().f_91075_;
        if (player != null && !player.m_20145_() && context.position != null) {
            Vec3 applyRotation = context.contraption.entity.reverseRotation(player.m_20182_().m_82546_(context.position), 1.0f);
            double dx = applyRotation.f_82479_;
            double dz = applyRotation.f_82481_;
            return AngleHelper.deg(-Mth.m_14136_((double)dz, (double)dx)) - 90.0f;
        }
        return 0.0f;
    }

    private boolean shouldRenderHat(MovementContext context) {
        CarriageContraptionEntity cce;
        AbstractContraptionEntity abstractContraptionEntity;
        CompoundTag data = context.data;
        if (!data.m_128441_("Conductor")) {
            data.m_128379_("Conductor", this.determineIfConducting(context));
        }
        return data.m_128471_("Conductor") && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)abstractContraptionEntity).hasSchedule();
    }

    private boolean determineIfConducting(MovementContext context) {
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        Direction assemblyDirection = carriageContraption.getAssemblyDirection();
        for (Direction direction : Iterate.directionsInAxis(assemblyDirection.m_122434_())) {
            if (!carriageContraption.inControl(context.localPos, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!this.shouldRender(context)) {
            return;
        }
        BlazeBurnerRenderer.renderInContraption(context, renderWorld, matrices, buffer, this.getHeadAngle(context), this.shouldRenderHat(context));
    }
}

