/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.simpleRelays;

import com.jozufozu.flywheel.core.virtual.VirtualEmptyModelData;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BracketedKineticBlockModel
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<BracketedModelData> BRACKET_PROPERTY = new ModelProperty();

    public BracketedKineticBlockModel(BakedModel template) {
        super(template);
    }

    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData blockEntityData) {
        if (VirtualEmptyModelData.is((IModelData)blockEntityData)) {
            return blockEntityData;
        }
        BracketedModelData data = new BracketedModelData();
        BracketedBlockEntityBehaviour attachmentBehaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (attachmentBehaviour != null) {
            data.putBracket(attachmentBehaviour.getBracket());
        }
        return new ModelDataMap.Builder().withInitial(BRACKET_PROPERTY, (Object)data).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        if (!VirtualEmptyModelData.is((IModelData)data)) {
            BracketedModelData pipeData;
            BakedModel bracket;
            if (data.hasProperty(BRACKET_PROPERTY) && (bracket = (pipeData = (BracketedModelData)data.getData(BRACKET_PROPERTY)).getBracket()) != null) {
                return bracket.getQuads(state, side, rand, data);
            }
            return Collections.emptyList();
        }
        return super.getQuads(state, side, rand, data);
    }

    private static class BracketedModelData {
        private BakedModel bracket;

        private BracketedModelData() {
        }

        public void putBracket(BlockState state) {
            if (state != null) {
                this.bracket = Minecraft.m_91087_().m_91289_().m_110910_(state);
            }
        }

        public BakedModel getBracket() {
            return this.bracket;
        }
    }
}

