/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.millstone;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MillstoneBlock
extends KineticBlock
implements IBE<MillstoneBlockEntity>,
ICogWheel {
    public MillstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.MILLSTONE;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, millstone -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = millstone.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.m_41619_()) {
                    emptyOutput = false;
                }
                player.m_150109_().m_150079_(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.f_41583_);
            }
            if (emptyOutput) {
                inv = millstone.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.m_150109_().m_150079_(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.f_41583_);
                }
            }
            millstone.m_6596_();
            millstone.sendData();
        });
        return InteractionResult.SUCCESS;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (entityIn.f_19853_.f_46443_) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        MillstoneBlockEntity millstone = null;
        for (BlockPos pos : Iterate.hereAndBelow(entityIn.m_142538_())) {
            if (millstone != null) continue;
            millstone = (MillstoneBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (millstone == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        LazyOptional capability = millstone.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!capability.isPresent()) {
            return;
        }
        ItemStack remainder = ((IItemHandler)capability.orElse((Object)new ItemStackHandler())).insertItem(0, itemEntity.m_32055_(), false);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
        if (remainder.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainder);
        }
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    @Override
    public Class<MillstoneBlockEntity> getBlockEntityClass() {
        return MillstoneBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends MillstoneBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.MILLSTONE.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

