/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class BeltModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<BeltBlockEntity.CasingType> CASING_PROPERTY = new ModelProperty();
    public static final ModelProperty<Boolean> COVER_PROPERTY = new ModelProperty();
    private static final SpriteShiftEntry SPRITE_SHIFT = AllSpriteShifts.ANDESIDE_BELT_CASING;

    public BeltModel(BakedModel template) {
        super(template);
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        if (!data.hasProperty(CASING_PROPERTY)) {
            return super.getParticleIcon(data);
        }
        BeltBlockEntity.CasingType type = (BeltBlockEntity.CasingType)((Object)data.getData(CASING_PROPERTY));
        if (type == BeltBlockEntity.CasingType.NONE || type == BeltBlockEntity.CasingType.BRASS) {
            return super.getParticleIcon(data);
        }
        return AllSpriteShifts.ANDESITE_CASING.getOriginal();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        boolean brassCasing;
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (!extraData.hasProperty(CASING_PROPERTY)) {
            return quads;
        }
        boolean cover = (Boolean)extraData.getData(COVER_PROPERTY);
        BeltBlockEntity.CasingType type = (BeltBlockEntity.CasingType)((Object)extraData.getData(CASING_PROPERTY));
        boolean bl = brassCasing = type == BeltBlockEntity.CasingType.BRASS;
        if (type == BeltBlockEntity.CasingType.NONE || brassCasing && !cover) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        if (cover) {
            boolean alongX;
            boolean bl2 = alongX = ((Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X;
            BakedModel coverModel = (brassCasing ? (alongX ? AllPartialModels.BRASS_BELT_COVER_X : AllPartialModels.BRASS_BELT_COVER_Z) : (alongX ? AllPartialModels.ANDESITE_BELT_COVER_X : AllPartialModels.ANDESITE_BELT_COVER_Z)).get();
            quads.addAll(coverModel.getQuads(state, side, rand, extraData));
        }
        if (brassCasing) {
            return quads;
        }
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            TextureAtlasSprite original = quad.m_173410_();
            if (original != SPRITE_SHIFT.getOriginal()) continue;
            BakedQuad newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, SPRITE_SHIFT.getTargetU(u));
                BakedQuadHelper.setV(vertexData, vertex, SPRITE_SHIFT.getTargetV(v));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

