/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.content.fluids.FlowSource;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.FluidNetwork;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.OpenEndedPipe;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;

public class PipeConnection {
    public Direction side;
    Couple<Float> pressure;
    Optional<FlowSource> source;
    Optional<FlowSource> previousSource;
    Optional<Flow> flow;
    boolean particleSplashNextTick;
    Optional<FluidNetwork> network;
    public static final int MAX_PARTICLE_RENDER_DISTANCE = 20;
    public static final int SPLASH_PARTICLE_AMOUNT = 1;
    public static final float IDLE_PARTICLE_SPAWN_CHANCE = 0.001f;
    public static final float RIM_RADIUS = 0.265625f;
    public static final Random r = new Random();

    public PipeConnection(Direction side) {
        this.side = side;
        this.pressure = Couple.create(() -> Float.valueOf(0.0f));
        this.flow = Optional.empty();
        this.previousSource = Optional.empty();
        this.source = Optional.empty();
        this.network = Optional.empty();
        this.particleSplashNextTick = false;
    }

    public FluidStack getProvidedFluid() {
        FluidStack empty = FluidStack.EMPTY;
        if (!this.hasFlow()) {
            return empty;
        }
        Flow flow = this.flow.get();
        if (!flow.inbound) {
            return empty;
        }
        if (!flow.complete) {
            return empty;
        }
        return flow.fluid;
    }

    public boolean flipFlowsIfPressureReversed() {
        if (!this.hasFlow()) {
            return false;
        }
        boolean singlePressure = this.comparePressure() != 0.0f && (this.getInboundPressure() == 0.0f || this.getOutwardPressure() == 0.0f);
        Flow flow = this.flow.get();
        if (!singlePressure || this.comparePressure() < 0.0f == flow.inbound) {
            return false;
        }
        boolean bl = flow.inbound = !flow.inbound;
        if (!flow.complete) {
            this.flow = Optional.empty();
        }
        return true;
    }

    public void manageSource(Level world, BlockPos pos) {
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return;
        }
        FlowSource flowSource = this.source.get();
        flowSource.manageSource(world);
    }

    public boolean manageFlows(Level world, BlockPos pos, FluidStack internalFluid, Predicate<FluidStack> extractionPredicate) {
        FluidStack provided;
        Optional<FluidNetwork> retainedNetwork = this.network;
        this.network = Optional.empty();
        if (!this.source.isPresent() && !this.determineSource(world, pos)) {
            return false;
        }
        FlowSource flowSource = this.source.get();
        if (!this.hasFlow()) {
            if (!this.hasPressure()) {
                return false;
            }
            boolean prioritizeInbound = this.comparePressure() < 0.0f;
            for (boolean trueFalse : Iterate.trueAndFalse) {
                boolean inbound;
                boolean bl = inbound = prioritizeInbound == trueFalse;
                if (this.pressure.get(inbound).floatValue() == 0.0f || !this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid)) continue;
                return true;
            }
            return false;
        }
        Flow flow = this.flow.get();
        FluidStack fluidStack = provided = flow.inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid;
        if (!this.hasPressure() || provided.isEmpty() || !provided.isFluidEqual(flow.fluid)) {
            this.flow = Optional.empty();
            return true;
        }
        if (flow.inbound != this.comparePressure() < 0.0f) {
            boolean inbound;
            boolean bl = inbound = !flow.inbound;
            if (inbound && !provided.isEmpty() || !inbound && !internalFluid.isEmpty()) {
                FluidPropagator.resetAffectedFluidNetworks(world, pos, this.side);
                this.tryStartingNewFlow(inbound, inbound ? flowSource.provideFluid(extractionPredicate) : internalFluid);
                return true;
            }
        }
        flowSource.whileFlowPresent(world, flow.inbound);
        if (!flowSource.isEndpoint()) {
            return false;
        }
        if (!flow.inbound) {
            return false;
        }
        this.network = retainedNetwork;
        if (!this.hasNetwork()) {
            this.network = Optional.of(new FluidNetwork(world, new BlockFace(pos, this.side), flowSource::provideHandler));
        }
        this.network.get().tick();
        return false;
    }

    private boolean tryStartingNewFlow(boolean inbound, FluidStack providedFluid) {
        if (providedFluid.isEmpty()) {
            return false;
        }
        Flow flow = new Flow(inbound, providedFluid);
        this.flow = Optional.of(flow);
        return true;
    }

    public boolean determineSource(Level world, BlockPos pos) {
        BlockPos relative = pos.m_142300_(this.side);
        if (world.m_6522_(relative.m_123341_() >> 4, relative.m_123343_() >> 4, ChunkStatus.f_62326_, false) == null) {
            return false;
        }
        BlockFace location = new BlockFace(pos, this.side);
        if (FluidPropagator.isOpenEnd((BlockGetter)world, pos, this.side)) {
            this.source = this.previousSource.orElse(null) instanceof OpenEndedPipe ? this.previousSource : Optional.of(new OpenEndedPipe(location));
            return true;
        }
        if (FluidPropagator.hasFluidCapability((BlockGetter)world, location.getConnectedPos(), this.side.m_122424_())) {
            this.source = Optional.of(new FlowSource.FluidHandler(location));
            return true;
        }
        FluidTransportBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, relative, FluidTransportBehaviour.TYPE);
        this.source = Optional.of(behaviour == null ? new FlowSource.Blocked(location) : new FlowSource.OtherPipe(location));
        return true;
    }

    public void tickFlowProgress(Level world, BlockPos pos) {
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        if (flow.fluid.isEmpty()) {
            return;
        }
        if (world.f_46443_) {
            if (!this.source.isPresent()) {
                this.determineSource(world, pos);
            }
            this.spawnParticles(world, pos, flow.fluid);
            if (this.particleSplashNextTick) {
                this.spawnSplashOnRim(world, pos, flow.fluid);
            }
            this.particleSplashNextTick = false;
        }
        float flowSpeed = 0.03125f + Mth.m_14036_((float)(this.pressure.get(flow.inbound).floatValue() / 128.0f), (float)0.0f, (float)1.0f) * 31.0f / 32.0f;
        flow.progress.setValue(Math.min(flow.progress.getValue() + flowSpeed, 1.0f));
        if (flow.progress.getValue() >= 1.0f) {
            flow.complete = true;
        }
    }

    public void serializeNBT(CompoundTag tag, boolean clientPacket) {
        CompoundTag connectionData = new CompoundTag();
        tag.m_128365_(this.side.m_122433_(), (Tag)connectionData);
        if (this.hasPressure()) {
            ListTag pressureData = new ListTag();
            pressureData.add((Object)FloatTag.m_128566_((float)this.getInboundPressure()));
            pressureData.add((Object)FloatTag.m_128566_((float)this.getOutwardPressure()));
            connectionData.m_128365_("Pressure", (Tag)pressureData);
        }
        if (this.hasOpenEnd()) {
            connectionData.m_128365_("OpenEnd", (Tag)((OpenEndedPipe)this.source.get()).serializeNBT());
        }
        if (this.hasFlow()) {
            CompoundTag flowData = new CompoundTag();
            Flow flow = this.flow.get();
            flow.fluid.writeToNBT(flowData);
            flowData.m_128379_("In", flow.inbound);
            if (!flow.complete) {
                flowData.m_128365_("Progress", (Tag)flow.progress.writeNBT());
            }
            connectionData.m_128365_("Flow", (Tag)flowData);
        }
    }

    private boolean hasOpenEnd() {
        return this.source.orElse(null) instanceof OpenEndedPipe;
    }

    public void deserializeNBT(CompoundTag tag, BlockPos blockEntityPos, boolean clientPacket) {
        CompoundTag connectionData = tag.m_128469_(this.side.m_122433_());
        if (connectionData.m_128441_("Pressure")) {
            ListTag pressureData = connectionData.m_128437_("Pressure", 5);
            this.pressure = Couple.create(Float.valueOf(pressureData.m_128775_(0)), Float.valueOf(pressureData.m_128775_(1)));
        } else {
            this.pressure.replace(f -> Float.valueOf(0.0f));
        }
        this.source = Optional.empty();
        if (connectionData.m_128441_("OpenEnd")) {
            this.source = Optional.of(OpenEndedPipe.fromNBT(connectionData.m_128469_("OpenEnd"), blockEntityPos));
        }
        if (connectionData.m_128441_("Flow")) {
            CompoundTag flowData = connectionData.m_128469_("Flow");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)flowData);
            boolean inbound = flowData.m_128471_("In");
            if (!this.flow.isPresent()) {
                this.flow = Optional.of(new Flow(inbound, fluid));
                if (clientPacket) {
                    this.particleSplashNextTick = true;
                }
            }
            Flow flow = this.flow.get();
            flow.fluid = fluid;
            flow.inbound = inbound;
            boolean bl = flow.complete = !flowData.m_128441_("Progress");
            if (!flow.complete) {
                flow.progress.readNBT(flowData.m_128469_("Progress"), clientPacket);
            } else {
                if (flow.progress.getValue() == 0.0f) {
                    flow.progress.startWithValue(1.0);
                }
                flow.progress.setValue(1.0);
            }
        } else {
            this.flow = Optional.empty();
        }
    }

    public float comparePressure() {
        return this.getOutwardPressure() - this.getInboundPressure();
    }

    public void wipePressure() {
        this.pressure.replace(f -> Float.valueOf(0.0f));
        if (this.source.isPresent()) {
            this.previousSource = this.source;
        }
        this.source = Optional.empty();
        this.resetNetwork();
    }

    public FluidStack provideOutboundFlow() {
        if (!this.hasFlow()) {
            return FluidStack.EMPTY;
        }
        Flow flow = this.flow.get();
        if (!flow.complete || flow.inbound) {
            return FluidStack.EMPTY;
        }
        return flow.fluid;
    }

    public void addPressure(boolean inbound, float pressure) {
        this.pressure = this.pressure.mapWithContext((f, in) -> Float.valueOf(in == inbound ? f.floatValue() + pressure : f.floatValue()));
    }

    public Couple<Float> getPressure() {
        return this.pressure;
    }

    public boolean hasPressure() {
        return this.getInboundPressure() != 0.0f || this.getOutwardPressure() != 0.0f;
    }

    private float getOutwardPressure() {
        return ((Float)this.pressure.getSecond()).floatValue();
    }

    private float getInboundPressure() {
        return ((Float)this.pressure.getFirst()).floatValue();
    }

    public boolean hasFlow() {
        return this.flow.isPresent();
    }

    public boolean hasNetwork() {
        return this.network.isPresent();
    }

    public void resetNetwork() {
        this.network.ifPresent(FluidNetwork::reset);
    }

    public void spawnSplashOnRim(Level world, BlockPos pos, FluidStack fluid) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.spawnSplashOnRimInner(world, pos, fluid));
    }

    public void spawnParticles(Level world, BlockPos pos, FluidStack fluid) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.spawnParticlesInner(world, pos, fluid));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticlesInner(Level world, BlockPos pos, FluidStack fluid) {
        if (world == Minecraft.m_91087_().f_91073_ && !PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, 1);
        } else if (r.nextFloat() < 0.001f) {
            this.spawnRimParticles(world, pos, fluid, 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSplashOnRimInner(Level world, BlockPos pos, FluidStack fluid) {
        if (world == Minecraft.m_91087_().f_91073_ && !PipeConnection.isRenderEntityWithinDistance(pos)) {
            return;
        }
        this.spawnRimParticles(world, pos, fluid, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnRimParticles(Level world, BlockPos pos, FluidStack fluid, int amount) {
        if (this.hasOpenEnd()) {
            this.spawnPouringLiquid(world, pos, fluid, amount);
            return;
        }
        ParticleOptions particle = FluidFX.getDrippingParticle(fluid);
        FluidFX.spawnRimParticles(world, pos, this.side, amount, particle, 0.265625f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnPouringLiquid(Level world, BlockPos pos, FluidStack fluid, int amount) {
        ParticleOptions particle = FluidFX.getFluidParticle(fluid);
        Vec3 directionVec = Vec3.m_82528_((Vec3i)this.side.m_122436_());
        if (!this.hasFlow()) {
            return;
        }
        Flow flow = this.flow.get();
        FluidFX.spawnPouringLiquid(world, pos, amount, particle, 0.265625f, directionVec, flow.inbound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isRenderEntityWithinDistance(BlockPos pos) {
        Entity renderViewEntity = Minecraft.m_91087_().m_91288_();
        if (renderViewEntity == null) {
            return false;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        return !(renderViewEntity.m_20182_().m_82554_(center) > 20.0);
    }

    public class Flow {
        public boolean complete;
        public boolean inbound;
        public LerpedFloat progress;
        public FluidStack fluid;

        public Flow(boolean inbound, FluidStack fluid) {
            this.inbound = inbound;
            this.fluid = fluid;
            this.progress = LerpedFloat.linear().startWithValue(0.0);
            this.complete = false;
        }
    }
}

