/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.blueprint;

import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintEntity;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.MultiItemValue;
import net.minecraftforge.items.ItemStackHandler;

public class BlueprintItem
extends Item {
    public BlueprintItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Direction face = ctx.m_43719_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_().m_142300_(face);
        if (player != null && !player.m_36204_(pos, face, stack)) {
            return InteractionResult.FAIL;
        }
        Level world = ctx.m_43725_();
        BlueprintEntity hangingentity = new BlueprintEntity(world, pos, face, face.m_122434_().m_122479_() ? Direction.DOWN : ctx.m_8125_());
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null) {
            EntityType.m_20620_((Level)world, (Player)player, (Entity)hangingentity, (CompoundTag)compoundnbt);
        }
        if (!hangingentity.m_7088_()) {
            return InteractionResult.CONSUME;
        }
        if (!world.f_46443_) {
            hangingentity.m_7084_();
            world.m_7967_((Entity)hangingentity);
        }
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean canPlace(Player p_200127_1_, Direction p_200127_2_, ItemStack p_200127_3_, BlockPos p_200127_4_) {
        return p_200127_1_.m_36204_(p_200127_4_, p_200127_2_, p_200127_3_);
    }

    public static void assignCompleteRecipe(ItemStackHandler inv, Recipe<?> recipe) {
        int i;
        NonNullList ingredients = recipe.m_7527_();
        for (i = 0; i < 9; ++i) {
            inv.setStackInSlot(i, ItemStack.f_41583_);
        }
        inv.setStackInSlot(9, recipe.m_8043_());
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            for (int row = 0; row < shapedRecipe.getRecipeHeight(); ++row) {
                for (int col = 0; col < shapedRecipe.getRecipeWidth(); ++col) {
                    inv.setStackInSlot(row * 3 + col, BlueprintItem.convertIngredientToFilter((Ingredient)ingredients.get(row * shapedRecipe.getRecipeWidth() + col)));
                }
            }
        } else {
            for (i = 0; i < ingredients.size(); ++i) {
                inv.setStackInSlot(i, BlueprintItem.convertIngredientToFilter((Ingredient)ingredients.get(i)));
            }
        }
    }

    private static ItemStack convertIngredientToFilter(Ingredient ingredient) {
        Ingredient.Value[] acceptedItems = ingredient.f_43902_;
        if (acceptedItems == null || acceptedItems.length > 18) {
            return ItemStack.f_41583_;
        }
        if (acceptedItems.length == 0) {
            return ItemStack.f_41583_;
        }
        if (acceptedItems.length == 1) {
            return BlueprintItem.convertIItemListToFilter(acceptedItems[0]);
        }
        ItemStack result = AllItems.FILTER.asStack();
        ItemStackHandler filterItems = FilterItem.getFilterItems(result);
        for (int i = 0; i < acceptedItems.length; ++i) {
            filterItems.setStackInSlot(i, BlueprintItem.convertIItemListToFilter(acceptedItems[i]));
        }
        result.m_41784_().m_128365_("Items", (Tag)filterItems.serializeNBT());
        return result;
    }

    private static ItemStack convertIItemListToFilter(Ingredient.Value itemList) {
        Iterator iterator;
        Collection stacks = itemList.m_6223_();
        if (itemList instanceof Ingredient.ItemValue && (iterator = stacks.iterator()).hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            return itemStack;
        }
        if (itemList instanceof Ingredient.TagValue) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)itemList.m_6544_(), (String)"tag"));
            ItemStack filterItem = AllItems.ATTRIBUTE_FILTER.asStack();
            filterItem.m_41784_().m_128405_("WhitelistMode", AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ.ordinal());
            ListTag attributes = new ListTag();
            ItemAttribute.InTag at = new ItemAttribute.InTag((TagKey<Item>)ItemTags.create((ResourceLocation)resourcelocation));
            CompoundTag compoundNBT = new CompoundTag();
            at.serializeNBT(compoundNBT);
            compoundNBT.m_128379_("Inverted", false);
            attributes.add((Object)compoundNBT);
            filterItem.m_41784_().m_128365_("MatchedAttributes", (Tag)attributes);
            return filterItem;
        }
        if (itemList instanceof MultiItemValue) {
            ItemStack result = AllItems.FILTER.asStack();
            ItemStackHandler filterItems = FilterItem.getFilterItems(result);
            int i = 0;
            for (ItemStack itemStack : stacks) {
                if (i >= 18) break;
                filterItems.setStackInSlot(i++, itemStack);
            }
            CompoundTag tag = result.m_41784_();
            tag.m_128365_("Items", (Tag)filterItems.serializeNBT());
            tag.m_128379_("RespectNBT", true);
            return result;
        }
        return ItemStack.f_41583_;
    }
}

