/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.content.equipment.armor.CapacityEnchantment;
import com.simibubi.create.foundation.item.LayeredArmorItem;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BacktankItem
extends BaseArmorItem
implements CapacityEnchantment.ICapacityEnchantable {
    public static final EquipmentSlot SLOT = EquipmentSlot.CHEST;
    public static final int BAR_COLOR = 0xEFEFEF;
    private final Supplier<BacktankBlockItem> blockItem;

    public BacktankItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc, Supplier<BacktankBlockItem> placeable) {
        super(material, SLOT, properties, textureLoc);
        this.blockItem = placeable;
    }

    @Nullable
    public static BacktankItem getWornBy(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Item item = livingEntity.m_6844_(SLOT).m_41720_();
        if (!(item instanceof BacktankItem)) {
            return null;
        }
        BacktankItem item2 = (BacktankItem)item;
        return item2;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.blockItem.get().m_6225_(ctx);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack p_77616_1_) {
        return true;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!this.m_41389_(tab)) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Air", BacktankUtil.maxAirWithoutEnchants());
        stack.m_41751_(nbt);
        items.add((Object)stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * Mth.m_14036_((float)((float)BacktankItem.getRemainingAir(stack) / (float)BacktankUtil.maxAir(stack)), (float)0.0f, (float)1.0f));
    }

    public int m_142159_(ItemStack stack) {
        return 0xEFEFEF;
    }

    public Block getBlock() {
        return this.blockItem.get().m_40614_();
    }

    public static int getRemainingAir(ItemStack stack) {
        CompoundTag orCreateTag = stack.m_41784_();
        return orCreateTag.m_128451_("Air");
    }

    public static class BacktankBlockItem
    extends BlockItem {
        private final Supplier<Item> actualItem;

        public BacktankBlockItem(Block block, Supplier<Item> actualItem, Item.Properties properties) {
            super(block, properties);
            this.actualItem = actualItem;
        }

        public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        }

        public String m_5524_() {
            return this.m_41467_();
        }

        public Item getActualItem() {
            return this.actualItem.get();
        }
    }

    public static class Layered
    extends BacktankItem
    implements LayeredArmorItem {
        public Layered(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc, Supplier<BacktankBlockItem> placeable) {
            super(material, properties, textureLoc, placeable);
        }

        @Override
        public String getArmorTextureLocation(LivingEntity entity, EquipmentSlot slot, ItemStack stack, int layer) {
            return String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d.png", this.textureLoc.m_135827_(), this.textureLoc.m_135815_(), layer);
        }
    }
}

