/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.girder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class GirderWrenchBehavior {
    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        HitResult hitResult;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null || !((hitResult = mc.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_6144_()) {
            return;
        }
        if (!AllBlocks.METAL_GIRDER.has(world.m_8055_(pos))) {
            return;
        }
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        Pair<Direction, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, (Level)world, pos);
        if (dirPair == null) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 edge = center.m_82549_(Vec3.m_82528_((Vec3i)dirPair.getFirst().m_122436_()).m_82490_(0.4));
        Direction.Axis[] axes = (Direction.Axis[])Arrays.stream(Iterate.axes).filter(axis -> axis != ((Direction)dirPair.getFirst()).m_122434_()).toArray(Direction.Axis[]::new);
        double normalMultiplier = dirPair.getSecond() == Action.PAIR ? 4.0 : 1.0;
        Vec3 corner1 = edge.m_82549_(Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axes[0], (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_()).m_82490_(0.3)).m_82549_(Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axes[1], (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_()).m_82490_(0.3)).m_82549_(Vec3.m_82528_((Vec3i)dirPair.getFirst().m_122436_()).m_82490_(0.1 * normalMultiplier));
        normalMultiplier = dirPair.getSecond() == Action.HORIZONTAL ? 9.0 : 2.0;
        Vec3 corner2 = edge.m_82549_(Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axes[0], (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).m_122436_()).m_82490_(0.3)).m_82549_(Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)axes[1], (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).m_122436_()).m_82490_(0.3)).m_82549_(Vec3.m_82528_((Vec3i)dirPair.getFirst().m_122424_().m_122436_()).m_82490_(0.1 * normalMultiplier));
        CreateClient.OUTLINER.showAABB("girderWrench", new AABB(corner1, corner2)).lineWidth(0.03125f).colored(new Color(127, 127, 127));
    }

    @Nullable
    private static Pair<Direction, Action> getDirectionAndAction(BlockHitResult result, Level world, BlockPos pos) {
        List<Pair<Direction, Action>> validDirections = GirderWrenchBehavior.getValidDirections((BlockGetter)world, pos);
        if (validDirections.isEmpty()) {
            return null;
        }
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, result.m_82450_(), validDirections.stream().map(Pair::getFirst).toList());
        if (directions.isEmpty()) {
            return null;
        }
        Direction dir = directions.get(0);
        return validDirections.stream().filter(pair -> pair.getFirst() == dir).findFirst().orElseGet(() -> Pair.of(dir, Action.SINGLE));
    }

    public static List<Pair<Direction, Action>> getValidDirections(BlockGetter level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (!AllBlocks.METAL_GIRDER.has(blockState)) {
            return Collections.emptyList();
        }
        return Arrays.stream(Iterate.directions).mapMulti((direction, consumer) -> {
            BlockState other = level.m_8055_(pos.m_142300_(direction));
            if (!((Boolean)blockState.m_61143_((Property)GirderBlock.X)).booleanValue() && !((Boolean)blockState.m_61143_((Property)GirderBlock.Z)).booleanValue()) {
                return;
            }
            if (direction.m_122434_() == Direction.Axis.Y) {
                if (!AllBlocks.METAL_GIRDER.has(other)) {
                    if ((Boolean)blockState.m_61143_((Property)GirderBlock.X) == false ^ (Boolean)blockState.m_61143_((Property)GirderBlock.Z) == false) {
                        consumer.accept(Pair.of(direction, Action.SINGLE));
                    }
                    return;
                }
                if (blockState.m_61143_((Property)GirderBlock.X) == blockState.m_61143_((Property)GirderBlock.Z)) {
                    return;
                }
                if (other.m_61143_((Property)GirderBlock.X) == other.m_61143_((Property)GirderBlock.Z)) {
                    return;
                }
                consumer.accept(Pair.of(direction, Action.PAIR));
                return;
            }
        }).toList();
    }

    public static boolean handleClick(Level level, BlockPos pos, BlockState state, BlockHitResult result) {
        Pair<Direction, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, level, pos);
        if (dirPair == null) {
            return false;
        }
        if (level.f_46443_) {
            return true;
        }
        if (!((Boolean)state.m_61143_((Property)GirderBlock.X)).booleanValue() && !((Boolean)state.m_61143_((Property)GirderBlock.Z)).booleanValue()) {
            return false;
        }
        Direction dir = dirPair.getFirst();
        BlockPos otherPos = pos.m_142300_(dir);
        BlockState other = level.m_8055_(otherPos);
        if (dir == Direction.UP) {
            level.m_7731_(pos, GirderWrenchBehavior.postProcess((BlockState)state.m_61122_((Property)GirderBlock.TOP)), 18);
            if (dirPair.getSecond() == Action.PAIR && AllBlocks.METAL_GIRDER.has(other)) {
                level.m_7731_(otherPos, GirderWrenchBehavior.postProcess((BlockState)other.m_61122_((Property)GirderBlock.BOTTOM)), 18);
            }
            return true;
        }
        if (dir == Direction.DOWN) {
            level.m_7731_(pos, GirderWrenchBehavior.postProcess((BlockState)state.m_61122_((Property)GirderBlock.BOTTOM)), 18);
            if (dirPair.getSecond() == Action.PAIR && AllBlocks.METAL_GIRDER.has(other)) {
                level.m_7731_(otherPos, GirderWrenchBehavior.postProcess((BlockState)other.m_61122_((Property)GirderBlock.TOP)), 18);
            }
            return true;
        }
        return true;
    }

    private static BlockState postProcess(BlockState newState) {
        if (((Boolean)newState.m_61143_((Property)GirderBlock.TOP)).booleanValue() && ((Boolean)newState.m_61143_((Property)GirderBlock.BOTTOM)).booleanValue()) {
            return newState;
        }
        if (newState.m_61143_(GirderBlock.AXIS) != Direction.Axis.Y) {
            return newState;
        }
        return (BlockState)newState.m_61124_(GirderBlock.AXIS, (Comparable)((Boolean)newState.m_61143_((Property)GirderBlock.X) != false ? Direction.Axis.X : Direction.Axis.Z));
    }

    private static enum Action {
        SINGLE,
        PAIR,
        HORIZONTAL;

    }
}

