/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.piston.PistonLighter;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class PistonContraption
extends TranslatingContraption {
    protected int extensionLength;
    protected int initialExtensionProgress;
    protected Direction orientation;
    private AABB pistonExtensionCollisionBox;
    private boolean retract;

    @Override
    public ContraptionType getType() {
        return ContraptionType.PISTON;
    }

    public PistonContraption() {
    }

    public PistonContraption(Direction direction, boolean retract) {
        this.orientation = direction;
        this.retract = retract;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.collectExtensions(world, pos, this.orientation)) {
            return false;
        }
        int count = this.blocks.size();
        if (!this.searchMovedStructure(world, this.anchor, this.retract ? this.orientation.m_122424_() : this.orientation)) {
            return false;
        }
        this.bounds = this.blocks.size() == count ? this.pistonExtensionCollisionBox : this.bounds.m_82367_(this.pistonExtensionCollisionBox);
        this.startMoving(world);
        return true;
    }

    private boolean collectExtensions(Level world, BlockPos pos, Direction direction) throws AssemblyException {
        ArrayList<StructureTemplate.StructureBlockInfo> poles = new ArrayList<StructureTemplate.StructureBlockInfo>();
        BlockPos actualStart = pos;
        BlockState nextBlock = world.m_8055_(actualStart.m_142300_(direction));
        int extensionsInFront = 0;
        BlockState blockState = world.m_8055_(pos);
        boolean sticky = MechanicalPistonBlock.isStickyPiston(blockState);
        if (!MechanicalPistonBlock.isPiston(blockState)) {
            return false;
        }
        if (blockState.m_61143_(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.m_122434_()) || MechanicalPistonBlock.isPistonHead(nextBlock) && nextBlock.m_61143_((Property)BlockStateProperties.f_61372_) == direction) {
                actualStart = actualStart.m_142300_(direction);
                poles.add(new StructureTemplate.StructureBlockInfo(actualStart, (BlockState)nextBlock.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction), null));
                ++extensionsInFront;
                if (MechanicalPistonBlock.isPistonHead(nextBlock)) break;
                nextBlock = world.m_8055_(actualStart.m_142300_(direction));
                if (extensionsInFront <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
                throw AssemblyException.tooManyPistonPoles();
            }
        }
        if (extensionsInFront == 0) {
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)((BlockState)AllBlocks.MECHANICAL_PISTON_HEAD.getDefaultState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction)).m_61124_((Property)BlockStateProperties.f_61396_, (Comparable)(sticky ? PistonType.STICKY : PistonType.DEFAULT)), null));
        } else {
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction), null));
        }
        BlockPos end = pos;
        nextBlock = world.m_8055_(end.m_142300_(direction.m_122424_()));
        int extensionsInBack = 0;
        while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.m_122434_())) {
            end = end.m_142300_(direction.m_122424_());
            poles.add(new StructureTemplate.StructureBlockInfo(end, (BlockState)nextBlock.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction), null));
            nextBlock = world.m_8055_(end.m_142300_(direction.m_122424_()));
            if (extensionsInFront + ++extensionsInBack <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.anchor = pos.m_5484_(direction, this.initialExtensionProgress + 1);
        this.extensionLength = extensionsInBack + extensionsInFront;
        this.initialExtensionProgress = extensionsInFront;
        this.pistonExtensionCollisionBox = new AABB(BlockPos.f_121853_.m_5484_(direction, -1), BlockPos.f_121853_.m_5484_(direction, -this.extensionLength - 1)).m_82363_(1.0, 1.0, 1.0);
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (StructureTemplate.StructureBlockInfo pole : poles) {
            BlockPos relPos = pole.f_74675_.m_5484_(direction, -extensionsInFront);
            BlockPos localPos = relPos.m_141950_((Vec3i)this.anchor);
            this.getBlocks().put(localPos, new StructureTemplate.StructureBlockInfo(localPos, pole.f_74676_, null));
        }
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return this.pistonExtensionCollisionBox.m_82390_(VecHelper.getCenterOf((Vec3i)pos.m_141950_((Vec3i)this.anchor)));
    }

    @Override
    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction direction, Queue<BlockPos> frontier) throws AssemblyException {
        boolean retracting;
        frontier.clear();
        boolean sticky = MechanicalPistonBlock.isStickyPiston(world.m_8055_(pos.m_5484_(this.orientation, -1)));
        boolean bl = retracting = direction != this.orientation;
        if (retracting && !sticky) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.server().kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            BlockPos currentPos = pos.m_5484_(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && world.m_151570_(currentPos)) {
                return true;
            }
            if (!world.m_46749_(currentPos)) {
                throw AssemblyException.unloadedChunk(currentPos);
            }
            BlockState state = world.m_8055_(currentPos);
            if (!BlockMovementChecks.isMovementNecessary(state, world, currentPos)) {
                return true;
            }
            if (BlockMovementChecks.isBrittle(state) && !(state.m_60734_() instanceof WoolCarpetBlock)) {
                return true;
            }
            if (MechanicalPistonBlock.isPistonHead(state) && state.m_61143_((Property)BlockStateProperties.f_61372_) == direction.m_122424_()) {
                return true;
            }
            if (!BlockMovementChecks.isMovementAllowed(state, world, currentPos)) {
                if (retracting) {
                    return true;
                }
                throw AssemblyException.unmovableBlock(currentPos, state);
            }
            if (retracting && state.m_60811_() == PushReaction.PUSH_ONLY) {
                return true;
            }
            frontier.add(currentPos);
            if (!BlockMovementChecks.isNotSupportive(state, this.orientation)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void addBlock(BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        super.addBlock(pos.m_5484_(this.orientation, -this.initialExtensionProgress), capture);
    }

    @Override
    public BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.m_141950_((Vec3i)this.anchor).m_5484_(this.orientation, -this.initialExtensionProgress);
    }

    @Override
    protected boolean customBlockPlacement(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos pistonPos = this.anchor.m_5484_(this.orientation, -1);
        BlockState pistonState = world.m_8055_(pistonPos);
        BlockEntity be = world.m_7702_(pistonPos);
        if (pos.equals((Object)pistonPos)) {
            if (be == null || be.m_58901_()) {
                return true;
            }
            if (!MechanicalPistonBlock.isExtensionPole(state) && MechanicalPistonBlock.isPiston(pistonState)) {
                world.m_7731_(pistonPos, (BlockState)pistonState.m_61124_(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)), 19);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean customBlockRemoval(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos pistonPos = this.anchor.m_5484_(this.orientation, -1);
        BlockState blockState = world.m_8055_(pos);
        if (pos.equals((Object)pistonPos) && MechanicalPistonBlock.isPiston(blockState)) {
            world.m_7731_(pos, (BlockState)blockState.m_61124_(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.MOVING)), 82);
            return true;
        }
        return false;
    }

    @Override
    public void readNBT(Level world, CompoundTag nbt, boolean spawnData) {
        super.readNBT(world, nbt, spawnData);
        this.initialExtensionProgress = nbt.m_128451_("InitialLength");
        this.extensionLength = nbt.m_128451_("ExtensionLength");
        this.orientation = Direction.m_122376_((int)nbt.m_128451_("Orientation"));
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("InitialLength", this.initialExtensionProgress);
        tag.m_128405_("ExtensionLength", this.extensionLength);
        tag.m_128405_("Orientation", this.orientation.m_122411_());
        return tag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new PistonLighter(this);
    }
}

