/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.Icon;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiUtils {
    private static final float U_SCALE = 0.00390625f;
    private static final float V_SCALE = 0.00390625f;
    private static final ScissorsStack STACK = new ScissorsStack();

    public static float calculateScrollOffset(float width, Font font, ConfigElement.GuiAlign align, Component text, int seed) {
        int textWidth = font.m_92852_((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.m_137550_() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            return (float)Mth.m_14139_((double)offset, (double)0.0, (double)diff);
        }
        return 0.0f;
    }

    public static void drawScrollingString(PoseStack stack, Font font, Component text, float x, float y, float width, float height, ConfigElement.GuiAlign align, int color, int seed) {
        int textWidth = font.m_92852_((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.m_137550_() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            GuiUtils.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.m_14139_((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.m_92889_(stack, text, f, f2 - (float)(9 / 3), color);
            GuiUtils.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.m_92889_(stack, text, f, f3 - (float)(9 / 3), color);
    }

    public static void drawScrollingShadowString(PoseStack stack, Font font, Component text, float x, float y, float width, float height, ConfigElement.GuiAlign align, int color, int seed) {
        int textWidth = font.m_92852_((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.m_137550_() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            GuiUtils.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.m_14139_((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.m_92763_(stack, text, f, f2 - (float)(9 / 3), color);
            GuiUtils.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.m_92763_(stack, text, f, f3 - (float)(9 / 3), color);
    }

    public static void pushScissors(int x, int y, int width, int height) {
        GuiUtils.pushScissors(new Rect(x, y, width, height));
    }

    public static void pushScissors(Rect rect) {
        STACK.push(rect);
        GuiUtils.applyScissors(rect);
    }

    public static void popScissors() {
        GuiUtils.applyScissors(STACK.pop());
    }

    private static void applyScissors(Rect rect) {
        if (rect == null) {
            RenderSystem.m_69471_();
            return;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        int bottom = rect.maxY;
        double scaledHeight = (double)window.m_85442_() / (double)window.m_85446_();
        double scaledWidth = (double)window.m_85441_() / (double)window.m_85445_();
        RenderSystem.m_69488_((int)((int)((double)rect.getX() * scaledWidth)), (int)((int)((double)window.m_85442_() - (double)bottom * scaledHeight)), (int)((int)((double)rect.getWidth() * scaledWidth)), (int)((int)((double)rect.getHeigth() * scaledHeight)));
    }

    public static void drawTextureWithBorder(PoseStack poseStack, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)res);
        GuiUtils.drawTexture(poseStack, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    private static void drawTexture(PoseStack poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTextured(poseStack, x, y, u, v, leftBorder, topBorder, zLevel, builder, matrix);
        GuiUtils.drawTextured(poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel, builder, matrix);
        GuiUtils.drawTextured(poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel, builder, matrix);
        GuiUtils.drawTextured(poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel, builder, matrix);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTextured(poseStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel, builder, matrix);
            GuiUtils.drawTextured(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel, builder, matrix);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTextured(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder, matrix);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTextured(poseStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder, matrix);
            GuiUtils.drawTextured(poseStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder, matrix);
        }
        tessellator.m_85914_();
    }

    private static void drawTextured(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder builder, Matrix4f matrix) {
        builder.m_85982_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
    }

    public static void drawTextureRegion(PoseStack stack, float x, float y, float width, float height, Icon icon, float texWidth, float texHeight) {
        RenderSystem.m_157179_((int)0, (ResourceLocation)icon.getTexture());
        GuiUtils.drawTextureRegion(stack, x, y, icon.getX(), icon.getY(), width, height, texWidth, texHeight, icon.getSheetWidth(), icon.getSheetHeight());
    }

    public static void drawTextureRegion(PoseStack stack, float x, float y, int xOff, int yOff, float width, float height, Icon icon, float texWidth, float texHeight) {
        RenderSystem.m_157179_((int)0, (ResourceLocation)icon.getTexture());
        GuiUtils.drawTextureRegion(stack, x, y, icon.getX() + (float)xOff, icon.getY() + (float)yOff, width, height, texWidth, texHeight, icon.getSheetWidth(), icon.getSheetHeight());
    }

    public static void drawTextureRegion(PoseStack stack, float x, float y, float texX, float texY, float width, float height, float texWidth, float texHeight, float textureWidth, float textureHeight) {
        Matrix4f matrix = stack.m_85850_().m_85861_();
        float maxX = x + width;
        float maxY = y + height;
        float t_minX = texX / textureWidth;
        float t_minY = texY / textureHeight;
        float t_maxX = (texX + texWidth) / textureWidth;
        float t_maxY = (texY + texHeight) / textureHeight;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, x, maxY, 0.0f).m_7421_(t_minX, t_maxY).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, maxY, 0.0f).m_7421_(t_maxX, t_maxY).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, y, 0.0f).m_7421_(t_maxX, t_minY).m_5752_();
        bufferbuilder.m_85982_(matrix, x, y, 0.0f).m_7421_(t_minX, t_minY).m_5752_();
        tessellator.m_85914_();
    }

    public static class Rect {
        int minX;
        int minY;
        int maxX;
        int maxY;

        public Rect(int x, int y, int width, int heigth) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + heigth;
        }

        public void limit(Rect rect) {
            this.minX = Math.max(rect.minX, this.minX);
            this.minY = Math.max(rect.minY, this.minY);
            this.maxX = Math.min(rect.maxX, this.maxX);
            this.maxY = Math.min(rect.maxY, this.maxY);
        }

        public int getX() {
            return this.minX;
        }

        public int getY() {
            return this.minY;
        }

        public int getWidth() {
            return this.maxX - this.minX;
        }

        public int getHeigth() {
            return this.maxY - this.minY;
        }
    }

    public static class ScissorsStack {
        Deque<Rect> stack = new ArrayDeque<Rect>();

        public void push(Rect owner) {
            if (this.stack.isEmpty()) {
                this.stack.push(owner);
                return;
            }
            owner.limit(this.stack.peek());
        }

        public Rect pop() {
            this.stack.pop();
            return this.stack.peek();
        }
    }
}

