/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.config.SelectionElement;
import carbonconfiglib.gui.widgets.CarbonButton;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;

public class CompoundScreen
extends ListScreen {
    Screen prev;
    ICompoundNode compound;
    Button applyValue;
    Runnable closeListener = null;

    public CompoundScreen(ICompoundNode node, Screen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.prev = prev;
        this.compound = node;
        this.compound.createTemp();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_;
        this.applyValue = (Button)this.m_142416_((GuiEventListener)new CarbonButton(x - 82, y - 27, 80, 20, (Component)new TranslatableComponent("gui.carbonconfig.apply"), this::apply));
        this.m_142416_((GuiEventListener)new CarbonButton(x + 2, y - 27, 80, 20, (Component)new TranslatableComponent("gui.carbonconfig.back"), this::goBack));
    }

    @Override
    protected int getScrollPadding() {
        return 184;
    }

    @Override
    protected int getListWidth() {
        return 360;
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.applyValue.f_93623_ = this.compound.isValid();
    }

    public void m_7379_() {
        this.notifyClose();
        this.f_96541_.m_91152_(this.prev);
    }

    private void apply(Button button) {
        this.compound.apply();
        this.f_96541_.m_91152_(this.prev);
    }

    private void notifyClose() {
        this.compound.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    private void goBack(Button button) {
        if (this.compound.isChanged()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.notifyClose();
                }
                this.f_96541_.m_91152_((Screen)(T ? this.prev : this));
            }, (Component)new TranslatableComponent("gui.carbonconfig.warn.changed"), (Component)new TranslatableComponent("gui.carbonconfig.warn.changed.desc").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        this.notifyClose();
        this.f_96541_.m_91152_(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        List<? extends INode> values = this.compound.getValues();
        int m = values.size();
        block5: for (int i = 0; i < m; ++i) {
            INode node = values.get(i);
            switch (node.getNodeType()) {
                case COMPOUND: {
                    elements.accept(new CompoundElement(this.compound, node.asCompound()));
                    continue block5;
                }
                case LIST: {
                    elements.accept(new ArrayElement(this.compound, node.asArray()));
                    continue block5;
                }
                case SIMPLE: {
                    IValueNode value = node.asValue();
                    if (value.isForcingSuggestions()) {
                        elements.accept(new SelectionElement(this.compound, value));
                        continue block5;
                    }
                    ConfigElement element = value.getDataType().create(this.compound, value);
                    if (element == null) continue block5;
                    elements.accept(element);
                }
            }
        }
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(stack, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), 8.0f, -1);
    }
}

