/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.CompoundScreen;
import carbonconfiglib.gui.screen.ListSelectionScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.utils.structure.IStructuredData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ArrayScreen
extends ListScreen {
    Screen prev;
    IArrayNode array;
    IStructuredData.StructureType innerType;
    Runnable closeListener;

    public ArrayScreen(IArrayNode entry, Screen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(entry.getName(), customTexture);
        this.prev = prev;
        this.array = entry;
        this.innerType = entry.getInnerType();
        this.array.createTemp();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_;
        this.m_142416_((GuiEventListener)new CarbonButton(x - 92, y - 27, 80, 20, (Component)new TranslatableComponent("gui.carbonconfig.apply"), this::apply));
        this.m_142416_((GuiEventListener)new CarbonButton(x - 10, y - 27, 20, 20, (Component)new TextComponent("+"), this::createEntry));
        this.m_142416_((GuiEventListener)new CarbonButton(x + 12, y - 27, 80, 20, (Component)new TranslatableComponent("gui.carbonconfig.back"), this::goBack));
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    @Override
    protected boolean shouldHaveSearch() {
        return false;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    private void notifyClose() {
        this.array.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    public void m_7379_() {
        this.notifyClose();
        this.f_96541_.m_91152_(this.prev);
    }

    private void apply(Button button) {
        this.array.apply();
        this.f_96541_.m_91152_(this.prev);
    }

    private void goBack(Button button) {
        if (this.array.isChanged()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(T -> {
                if (T) {
                    this.notifyClose();
                }
                this.f_96541_.m_91152_((Screen)(T ? this.prev : this));
            }, (Component)new TranslatableComponent("gui.carbonconfig.warn.changed"), (Component)new TranslatableComponent("gui.carbonconfig.warn.changed.desc").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        this.notifyClose();
        this.f_96541_.m_91152_(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        switch (this.innerType) {
            case COMPOUND: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new CompoundElement(this.array, this.array.get(i).asCompound()));
                }
                break;
            }
            case LIST: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new ArrayElement(this.array, this.array.get(i).asArray()));
                }
                break;
            }
            case SIMPLE: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    IValueNode node = this.array.get(i).asValue();
                    ConfigElement element = node.getDataType().create(this.array, node);
                    if (element == null) continue;
                    elements.accept(element);
                }
                break;
            }
        }
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.f_96547_.m_92889_(stack, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), 30.0f, -1);
    }

    public void createEntry(Button button) {
        int size = this.array.size();
        this.array.createNode();
        if (this.array.getSuggestions().size() > 0) {
            ListSelectionScreen screen = new ListSelectionScreen(this, this.array.get(size), this.innerType == IStructuredData.StructureType.COMPOUND ? ListSelectionScreen.NodeSupplier.ofCompound(this.array) : ListSelectionScreen.NodeSupplier.ofValue(), this.getCustomTexture());
            screen.withListener(() -> this.postCreate(size, true), () -> this.array.removeNode(size)).disableAbortWarning();
            this.f_96541_.m_91152_((Screen)screen);
            return;
        }
        this.postCreate(size, false);
    }

    private void postCreate(int size, boolean reopen) {
        INode node = this.array.get(size);
        switch (node.getNodeType()) {
            case COMPOUND: {
                CompoundScreen compoundScreen = new CompoundScreen(node.asCompound(), this, this.getCustomTexture());
                compoundScreen.setAbortListener(() -> this.array.removeNode(size));
                this.f_96541_.m_91152_((Screen)compoundScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case LIST: {
                ArrayScreen arrayScreen = new ArrayScreen(node.asArray(), this, this.getCustomTexture());
                arrayScreen.setAbortListener(() -> this.array.removeNode(size));
                this.f_96541_.m_91152_((Screen)arrayScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case SIMPLE: {
                ConfigElement element = node.asValue().getDataType().create(this.array, node.asValue());
                if (element == null) break;
                this.addEntry(element);
                this.visibleList.addElement(element);
                this.visibleList.setScrollAmount(this.visibleList.m_93518_(), true);
            }
        }
        if (reopen) {
            this.f_96541_.m_91152_((Screen)this);
        }
    }

    @Override
    public void removeEntry(Element element) {
        int index = this.allEntries.indexOf((Object)element);
        if (index == -1) {
            return;
        }
        this.visibleList.removeElement(element);
        this.allEntries.remove(index);
        this.array.removeNode(index);
        this.visibleList.m_93410_(this.visibleList.m_93517_());
    }
}

