/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.jmoverlay.ftbchunks;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.XZ;
import frankv.jmi.JMI;
import frankv.jmi.jmoverlay.JMOverlayManager;
import frankv.jmi.jmoverlay.ToggleableOverlay;
import frankv.jmi.jmoverlay.ftbchunks.ClaimedChunkPolygon;
import frankv.jmi.jmoverlay.ftbchunks.ClaimingModeHandler;
import frankv.jmi.platform.Services;
import frankv.jmi.util.OverlayHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IThemeButton;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.FullscreenMapEvent;
import journeymap.client.api.model.IFullscreen;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.MapPolygonWithHoles;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.ChunkPos;

public enum ClaimingMode implements ToggleableOverlay
{
    INSTANCE;

    private IClientAPI jmAPI;
    private Minecraft mc = Minecraft.m_91087_();
    private final ClaimingModeHandler handler = new ClaimingModeHandler();
    private boolean activated = false;
    private PolygonOverlay claimAreaPolygon = null;
    private Set<ChunkPos> area = new HashSet<ChunkPos>();
    private String buttonLabel = "FTBChunks Claiming Mode";
    private final int order = 0;

    private ClaimingMode() {
        JMOverlayManager.INSTANCE.registerOverlay(this);
    }

    @Override
    public void init(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
    }

    private void removeOverlays() {
        if (this.claimAreaPolygon == null) {
            return;
        }
        this.jmAPI.remove((Displayable)this.claimAreaPolygon);
        ClaimedChunkPolygon.INSTANCE.showForceLoadedByArea(false);
        this.claimAreaPolygon = null;
        this.area.clear();
    }

    PolygonOverlay dragPolygon(XZ xz) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String displayId = "drag_polygon_" + xz.x + "_" + xz.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setFillColor(0xFFFFFF).setFillOpacity(0.3f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)xz.x, (int)10, (int)xz.z);
        return new PolygonOverlay("jmi", displayId, player.f_108545_.m_46472_(), shapeProps, polygon);
    }

    PolygonOverlay forceLoadedPolygon(ChunkDimPos pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String displayId = "ftb_force_loaded_" + pos.x + "_" + pos.z;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFF0000).setFillOpacity(0.0f);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.x, (int)10, (int)pos.z);
        return new PolygonOverlay("jmi", displayId, player.f_108545_.m_46472_(), shapeProps, polygon);
    }

    private void createClaimingAreaOverlays() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ChunkPos startPoint = new ChunkPos(player.m_146902_().f_45578_ - 7, player.m_146902_().f_45579_ - 7);
        String displayId = "claim_mode";
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(3.0f).setStrokeColor(0xFFFFFF).setStrokeOpacity(1.0f).setFillOpacity(0.0f);
        for (int x = 0; x < 15; ++x) {
            for (int z = 0; z < 15; ++z) {
                this.area.add(new ChunkPos(startPoint.f_45578_ + x, startPoint.f_45579_ + z));
            }
        }
        ClaimedChunkPolygon.INSTANCE.showForceLoadedByArea(true);
        List polygons = PolygonHelper.createChunksPolygon(this.area, (int)100);
        PolygonOverlay overlay = new PolygonOverlay("jmi", "claim_mode", player.f_19853_.m_46472_(), shapeProps, (MapPolygonWithHoles)polygons.get(0));
        OverlayHelper.showOverlay((Displayable)overlay);
        this.claimAreaPolygon = overlay;
    }

    public void onGuiScreen(Screen screen) {
        if (!this.isEnabled() || !this.activated) {
            return;
        }
        if (Objects.equals(Services.PLATFORM.getPlatformName(), "Forge") && screen instanceof IFullscreen) {
            return;
        }
        if (Objects.equals(Services.PLATFORM.getPlatformName(), "Fabric") && !(screen instanceof IFullscreen)) {
            return;
        }
        ClaimedChunkPolygon.INSTANCE.onClaiming(true);
        this.activated = false;
        this.removeOverlays();
    }

    @Override
    public void onToggle(IThemeButton button) {
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (!this.activated) {
            this.createClaimingAreaOverlays();
        } else {
            this.removeOverlays();
        }
        ClaimedChunkPolygon.INSTANCE.onClaiming(this.activated);
        this.activated = !this.activated;
        button.setToggled(Boolean.valueOf(this.activated));
    }

    @Override
    public void onJMEvent(ClientEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        switch (event.type) {
            case MAP_CLICKED: {
                if (!(event instanceof FullscreenMapEvent.ClickEvent.Pre)) break;
                this.getHandler().onPreClick((FullscreenMapEvent.ClickEvent)event);
                break;
            }
            case MAP_DRAGGED: {
                if (!(event instanceof FullscreenMapEvent.MouseDraggedEvent.Pre)) break;
                this.getHandler().onPreDrag((FullscreenMapEvent.MouseDraggedEvent)event);
                break;
            }
            case MAP_MOUSE_MOVED: {
                this.getHandler().onMouseMove((FullscreenMapEvent.MouseMoveEvent)event);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return JMI.ftbchunks;
    }

    @Override
    public String getButtonIconName() {
        return "grid";
    }

    public ClaimingModeHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    public PolygonOverlay getClaimAreaPolygon() {
        return this.claimAreaPolygon;
    }

    public Set<ChunkPos> getArea() {
        return this.area;
    }

    @Override
    public String getButtonLabel() {
        return this.buttonLabel;
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

